// TaurusInterface.cpp : Defines the exported functions for the DLL application.
//

#include <ctime>
#include <direct.h>
#include <locale.h> 
#include "stdafx.h"
#include "TaurusInterface.h"
#include "CTaurusInterface.h"

CTaurusInterfaceApp	clsTaurusInterface;

typedef enum
{
  DailyBook,
  MonthBook
} tBookType;

TAURUSINTERFACE_API bool verificarConexion( char * puertoConexion )
{
	DWORD dwReturn;
	dwReturn = clsTaurusInterface.dwVerificarConexion( puertoConexion );

	if(dwReturn == SUCCESS)
		return true;
	else
		return false;

}

char * GetOutFileName( char * outStr, char * NombreArchivoSalida, char * FileExtension, tBookType bookType )
{
  // Se considera los string NULL y vacio de la misma manera
  bool HaveOutputFileName = ( NombreArchivoSalida != NULL );
  bool HaveFileExtension = ( FileExtension != NULL );

  if ( HaveOutputFileName )
    HaveOutputFileName = ( strlen( NombreArchivoSalida ) > 0 );

  if ( HaveFileExtension )
    HaveFileExtension = ( strlen( FileExtension ) > 0 );

  //Si el nombre de archivo es NULL => generar uno
	if( !HaveOutputFileName )
  {
    //El archivo y la extension no pueden ser NULL simultaneamente
  	if( !HaveFileExtension )
	  	return NULL;

    //Obtener fecha
    time_t now = time(NULL);
    struct tm * timeinfo;
    timeinfo = localtime( &now );
    setlocale(LC_ALL, ""); 

    //agregar dir
    strcpy( outStr, "c:\\lventas\\" );
    _mkdir( outStr );

    //agregar mes y ao
    char buffer[20];
    strftime( buffer, 20, "%B %Y\\", timeinfo ); 
    strcat( outStr, buffer );

    //crear directorio destino
    _mkdir( outStr );

    //generar nombre de archivo
    char * FilePrefix;
    char * FileDateFormat;
    switch ( bookType )
    {
      case DailyBook:
        FilePrefix = "LV";
        //AAMMDD
        FileDateFormat = "%y%m%d";
        break;
      case MonthBook:
        FilePrefix = "LVM";
        //AAMM
        FileDateFormat = "%y%m";
        break;
      default:
        return NULL;
    }

    strcat( outStr, FilePrefix );
    strftime( buffer, 10, FileDateFormat, timeinfo );
    strcat( outStr, buffer );
    //agregar extension
    strcat( outStr, "." );
    strcat( outStr, FileExtension );
  }
  else
  {
    // Detectar si esta especificado path con letra de disco
	  if((isalpha(NombreArchivoSalida[0]) != 0) && (NombreArchivoSalida[1] == ':'))
	  {
	     strcpy(outStr,NombreArchivoSalida);
	  }
	  else
	  {
		  sprintf(outStr, ".\\");
		  strcat(outStr, NombreArchivoSalida);
	  }
  }

  return outStr;
}

TAURUSINTERFACE_API bool LeerLibroDiario(char * ZNro_Fecha, char * NombreArchivoSalida, char * FileExtension)
{
	DWORD dwReturn;
	char	szFileName[1024];

	if ( ZNro_Fecha == NULL )
		return false;

  GetOutFileName( szFileName, NombreArchivoSalida, FileExtension, DailyBook );

  // Verificar que el parametro sea un numero. En caso de ser el nro 0 => tampoco es un parametro valido
  int NumberDate = atoi( ZNro_Fecha );
  if ( NumberDate == 0 )
		return false;

  // Si el valor esta comprendido entre 1 y 9999 se lo considera un nro de Z
  // de lo contrario se lo considera una fecha
  if ( NumberDate < 9999 )
  {
	  dwReturn = clsTaurusInterface.dwLeerLibroZ(ZNro_Fecha, szFileName);
  }
  else
  {
	  dwReturn = clsTaurusInterface.dwLeerLibroDiario(ZNro_Fecha, szFileName);
  }
	if(dwReturn == SUCCESS)
		return true;
	else
		return false;
}

TAURUSINTERFACE_API bool LeerLibroMensual(char * FechaDesde, char * FechaHasta,
                                          char * NombreArchivoSalida, char * FileExtension)
{
	DWORD dwReturn;
	char	szFileName[1024];

	if((FechaDesde == NULL) || (FechaHasta == NULL) )
		return false;

  GetOutFileName( szFileName, NombreArchivoSalida, FileExtension, MonthBook );

	dwReturn = clsTaurusInterface.dwLeerLibroMensual( FechaDesde, FechaHasta , szFileName);

	if(dwReturn == SUCCESS)
		return true;
	else
		return false;
}

TAURUSINTERFACE_API bool GenerarLibroMensual( char * Directorio, char * NombreArchivoSalida,
                                              char * FileExtension)
{
	DWORD dwReturn;
	char	szFileName[1024];

	if ( Directorio == NULL )
		return false;

  GetOutFileName( szFileName, NombreArchivoSalida, FileExtension, MonthBook );

	dwReturn = clsTaurusInterface.dwGenerarLibroMensual(Directorio, szFileName);

	if(dwReturn == SUCCESS)
		return true;
	else
		return false;
}
