#include "functions.h"
#include "options.h"
#include "extensions.h"
#include "structsIn.h"
#include "structsOut.h"
#include "serial.h"
#include "utils.h"

#include "stdafx.h"
#include "utils.h"
#include "serial.h"
#include "selector.h"

#include "commands.h"
#include "options.h"
#include "functions.h"


int CPrinterInformation::iSelect_Function( int iCommand, void * vDataIn, void * vDataOut )
{
	switch( iCommand )
	{
		case OPTION_GROUP_PRINTER_INFORMATION_GET_PRINTER_STATUS:
			return iPrinter_Information_Get_Printer_Status( vDataIn, vDataOut );
		case OPTION_GROUP_PRINTER_INFORMATION_START_AUDIT_Z:
			return iPrinter_Information_Start_Audit_Z( vDataIn, vDataOut );
		case OPTION_GROUP_PRINTER_INFORMATION_START_AUDIT_FECHA:
			return iPrinter_Information_Start_Audit_Fecha( vDataIn, vDataOut );
		case OPTION_GROUP_PRINTER_INFORMATION_RUN_AUDIT:
			return 	iPrinter_Information_RunAudit( vDataIn, vDataOut );
		case OPTION_GROUP_PRINTER_INFORMATION_END_AUDIT:
			return 	iPrinter_Information_EndAudit( vDataIn, vDataOut );
		case OPTION_GROUP_PRINTER_INFORMATION_CANCEL_AUDIT:
			return 	iPrinter_Information_CancelAudit( vDataIn, vDataOut );
      case OPTION_GROUP_PRINTER_INFORMATION_GET_INFO_BTWN_DATES:
			return iPrinter_Information_GetInfoBtwnDates( vDataIn, vDataOut );
	}


	return SUCCESS;
}

int CPrinterInformation::iPrinter_Information_Get_Printer_Status( void * vDataIn, void * vDataOut )
{
	PSTPRINTER_INFORMATION_PRINTER_STATUS_IN	pstIn  = (PSTPRINTER_INFORMATION_PRINTER_STATUS_IN)		vDataIn;
	PSTPRINTER_INFORMATION_PRINTER_STATUS_OUT	pstOut = (PSTPRINTER_INFORMATION_PRINTER_STATUS_OUT)	vDataOut;

	int iAnswer, iAnswerSize;

	_vSerial_Purge_Message();
	iAnswer = _iSerial_Add_FieldEx( (unsigned char *) CMD_PRINTER_INFORMATION_GET_PRINTER_STATUS, strlen( (const char*)CMD_PRINTER_INFORMATION_GET_PRINTER_STATUS), MESSAGE_TYPE_BINARY, true );

	if( pstIn )
	{
		switch( pstIn->iCommandExtension )
		{
			case EXTENSION_RESERVED:
			default:
				iAnswer = _iSerial_Add_FieldEx( (unsigned char *) EXT_RESERVED, strlen( (const char*)EXT_RESERVED), MESSAGE_TYPE_BINARY, false );
		}
	}
	else
		iAnswer = _iSerial_Add_FieldEx( (unsigned char *) EXT_RESERVED, strlen( (const char*)EXT_RESERVED), MESSAGE_TYPE_BINARY, false );


	iAnswer = _iSerial_Send_Message();

	if( iAnswer != SERIAL_NO_ERROR )
		return iAnswer;

	while( _iSerial_Get_Comm_State() == SERIAL_STATE_BUSY );

	iAnswer = _iSerial_Get_Last_Comm_Error();

	if( pstOut != 0x00 && iAnswer == SERIAL_NO_ERROR )
	{
		iAnswer = _iSerial_Get_FieldEx( &pstOut->stFixedAnswer.usPrinterStatus, &iAnswerSize, ANSWER_FIELD_PRINTER_STATUS, ANSWER_TYPE_UNSIGNED_SHORT );
		iAnswer = _iSerial_Get_FieldEx( &pstOut->stFixedAnswer.usFiscalStatus, &iAnswerSize, ANSWER_FIELD_FISCAL_STATUS, ANSWER_TYPE_UNSIGNED_SHORT );
		iAnswer = _iSerial_Get_FieldEx( &pstOut->stFixedAnswer.usResponse, &iAnswerSize, ANSWER_FIELD_COMMAND_RESPONSE, ANSWER_TYPE_UNSIGNED_SHORT );
	}

	return iAnswer;
}

int CPrinterInformation::iPrinter_Information_Start_Audit_Z( void * vDataIn, void * vDataOut )
{
	PSTPRINTER_INFORMATION_START_AUDIT_Z_IN	pstIn  = (PSTPRINTER_INFORMATION_START_AUDIT_Z_IN)	vDataIn;
	PSTPRINTER_INFORMATION_START_AUDIT_Z_OUT	pstOut = (PSTPRINTER_INFORMATION_START_AUDIT_Z_OUT)vDataOut;
	int	iAnswer, iAnswerSize;

	_vSerial_Purge_Message();

	if( pstIn == 0x00 )
		return ERROR_SERIAL_PARAMETER_NULL;

	iAnswer = _iSerial_Add_FieldEx( (unsigned char *) CMD_PRINTER_INFORMATION_START_AUDIT_Z, strlen( (const char*)CMD_PRINTER_INFORMATION_START_AUDIT_Z), MESSAGE_TYPE_BINARY, true );

	if( pstIn )
	{
		switch( pstIn->iCommandExtension )
		{
			case EXTENSION_PRINTER_DONT_PRINT_AUDIT_RZ:
				iAnswer = _iSerial_Add_FieldEx( (unsigned char *) EXT_PRINTER_DONT_PRINT_AUDIT_RZ, strlen( (const char*)EXT_PRINTER_DONT_PRINT_AUDIT_RZ), MESSAGE_TYPE_BINARY, true );
				break;
			case EXTENSION_PRINTER_DONT_PRINT_AUDIT_MONTH:
				iAnswer = _iSerial_Add_FieldEx( (unsigned char *) EXT_PRINTER_DONT_PRINT_AUDIT_MONTH, strlen( (const char*)EXT_PRINTER_DONT_PRINT_AUDIT_MONTH), MESSAGE_TYPE_BINARY, true );
				break;
			case EXTENSION_PRINTER_DONT_PRINT_AUDIT_RESUMED:
				iAnswer = _iSerial_Add_FieldEx( (unsigned char *) EXT_PRINTER_DONT_PRINT_AUDIT_RESUMED, strlen( (const char*)EXT_PRINTER_DONT_PRINT_AUDIT_RESUMED), MESSAGE_TYPE_BINARY, true );
				break;
			case EXTENSION_PRINTER_PRINT_AUDIT_RZ:
				iAnswer = _iSerial_Add_FieldEx( (unsigned char *) EXT_PRINTER_PRINT_AUDIT_RZ, strlen( (const char*)EXT_PRINTER_PRINT_AUDIT_RZ), MESSAGE_TYPE_BINARY, true );
				break;
			case EXTENSION_PRINTER_PRINT_AUDIT_MONTH:
				iAnswer = _iSerial_Add_FieldEx( (unsigned char *) EXT_PRINTER_PRINT_AUDIT_MONTH, strlen( (const char*)EXT_PRINTER_PRINT_AUDIT_MONTH), MESSAGE_TYPE_BINARY, true );
				break;
			case EXTENSION_PRINTER_PRINT_AUDIT_RESUMED:
				iAnswer = _iSerial_Add_FieldEx( (unsigned char *) EXT_PRINTER_PRINT_AUDIT_RESUMED, strlen( (const char*)EXT_PRINTER_PRINT_AUDIT_RESUMED), MESSAGE_TYPE_BINARY, true );
				break;
		}
		iAnswer = _iSerial_Add_FieldEx( (unsigned char *) pstIn->szZInicial, strlen( (const char*)  pstIn->szZInicial ), MESSAGE_TYPE_ASCII, true );

		iAnswer = _iSerial_Add_FieldEx( (unsigned char *) pstIn->szZFinal, strlen( (const char*)  pstIn->szZFinal ), MESSAGE_TYPE_ASCII, false );
	}

	iAnswer = _iSerial_Send_Message();

	if( iAnswer != SERIAL_NO_ERROR )
		return iAnswer;

	while( _iSerial_Get_Comm_State() == SERIAL_STATE_BUSY );

	iAnswer = _iSerial_Get_Last_Comm_Error();

	if( pstOut != 0x00 && iAnswer == SERIAL_NO_ERROR )
	{
		iAnswer = _iSerial_Get_FieldEx( &pstOut->stFixedAnswer.usPrinterStatus, &iAnswerSize, ANSWER_FIELD_PRINTER_STATUS, ANSWER_TYPE_UNSIGNED_SHORT );
		iAnswer = _iSerial_Get_FieldEx( &pstOut->stFixedAnswer.usFiscalStatus, &iAnswerSize, ANSWER_FIELD_FISCAL_STATUS, ANSWER_TYPE_UNSIGNED_SHORT );
		iAnswer = _iSerial_Get_FieldEx( &pstOut->stFixedAnswer.usResponse, &iAnswerSize, ANSWER_FIELD_COMMAND_RESPONSE, ANSWER_TYPE_UNSIGNED_SHORT );

	}

	return iAnswer;
}

int CPrinterInformation::iPrinter_Information_GetInfoBtwnDates( void * vDataIn, void * vDataOut )
{
	PSTPRINTER_INFORMATION_GET_INFO_BTWN_DATES_IN	pstIn  = (PSTPRINTER_INFORMATION_GET_INFO_BTWN_DATES_IN)	vDataIn;
	PSTPRINTER_INFORMATION_GET_INFO_BTWN_DATES_OUT	pstOut = (PSTPRINTER_INFORMATION_GET_INFO_BTWN_DATES_OUT)vDataOut;
	int iAnswer, iAnswerSize, iFieldCounter;

	_vSerial_Purge_Message();

	if( pstIn == 0x00 )
		return ERROR_SERIAL_PARAMETER_NULL;

	iAnswer = _iSerial_Add_FieldEx( (unsigned char *) CMD_PRINTER_INFORMATION_GET_INFO_BTWN_DATES, strlen( (const char*)CMD_PRINTER_INFORMATION_GET_INFO_BTWN_DATES), MESSAGE_TYPE_BINARY, true );

	iAnswer = _iSerial_Add_FieldEx( (unsigned char *) EXT_RESERVED, strlen( (const char*)EXT_RESERVED), MESSAGE_TYPE_BINARY, true );

   iAnswer = _iSerial_Add_FieldEx( (unsigned char *) pstIn->szFechaInicial, strlen( (const char*)  pstIn->szFechaInicial ), MESSAGE_TYPE_ASCII, true );

	iAnswer = _iSerial_Add_FieldEx( (unsigned char *) pstIn->szFechaFinal, strlen( (const char*)  pstIn->szFechaFinal ), MESSAGE_TYPE_ASCII, false );

	iAnswer = _iSerial_Send_Message();

	if( iAnswer != SERIAL_NO_ERROR )
		return iAnswer;

	while( _iSerial_Get_Comm_State() == SERIAL_STATE_BUSY );

	iAnswer = _iSerial_Get_Last_Comm_Error();

	if( pstOut != 0x00 && iAnswer == SERIAL_NO_ERROR )
	{
		iAnswer = _iSerial_Get_FieldEx( &pstOut->stFixedAnswer.usPrinterStatus, &iAnswerSize, ANSWER_FIELD_PRINTER_STATUS, ANSWER_TYPE_UNSIGNED_SHORT );
		iAnswer = _iSerial_Get_FieldEx( &pstOut->stFixedAnswer.usFiscalStatus, &iAnswerSize, ANSWER_FIELD_FISCAL_STATUS, ANSWER_TYPE_UNSIGNED_SHORT );
		iAnswer = _iSerial_Get_FieldEx( &pstOut->stFixedAnswer.usResponse, &iAnswerSize, ANSWER_FIELD_COMMAND_RESPONSE, ANSWER_TYPE_UNSIGNED_SHORT );

		iFieldCounter = _iSerial_Get_Field_Counter();

		if( iFieldCounter > ANSWER_FIXED_FIELDS_COUNTER )
		{
         iAnswer = _iSerial_Get_FieldEx( &pstOut->FirstZNum, &iAnswerSize, ANSWER_FIELD_1, ANSWER_TYPE_INT );
         iAnswer = _iSerial_Get_FieldEx( &pstOut->LastZNum, &iAnswerSize, ANSWER_FIELD_2, ANSWER_TYPE_INT );
		}
	}

	return iAnswer;
}

int CPrinterInformation::iPrinter_Information_Start_Audit_Fecha( void * vDataIn, void * vDataOut )
{
	PSTPRINTER_INFORMATION_START_AUDIT_FECHA_IN	pstIn  = (PSTPRINTER_INFORMATION_START_AUDIT_FECHA_IN)	vDataIn;
	PSTPRINTER_INFORMATION_START_AUDIT_FECHA_OUT	pstOut = (PSTPRINTER_INFORMATION_START_AUDIT_FECHA_OUT)vDataOut;
	int	iAnswer, iAnswerSize;

	_vSerial_Purge_Message();

	if( pstIn == 0x00 )
		return ERROR_SERIAL_PARAMETER_NULL;

	iAnswer = _iSerial_Add_FieldEx( (unsigned char *) CMD_PRINTER_INFORMATION_START_AUDIT_FECHA, strlen( (const char*)CMD_PRINTER_INFORMATION_START_AUDIT_FECHA), MESSAGE_TYPE_BINARY, true );

	if( pstIn )
	{
		switch( pstIn->iCommandExtension )
		{
			case EXTENSION_PRINTER_DONT_PRINT_AUDIT_RZ:
				iAnswer = _iSerial_Add_FieldEx( (unsigned char *) EXT_PRINTER_DONT_PRINT_AUDIT_RZ, strlen( (const char*)EXT_PRINTER_DONT_PRINT_AUDIT_RZ), MESSAGE_TYPE_BINARY, true );
				break;
			case EXTENSION_PRINTER_DONT_PRINT_AUDIT_MONTH:
				iAnswer = _iSerial_Add_FieldEx( (unsigned char *) EXT_PRINTER_DONT_PRINT_AUDIT_MONTH, strlen( (const char*)EXT_PRINTER_DONT_PRINT_AUDIT_MONTH), MESSAGE_TYPE_BINARY, true );
				break;
			case EXTENSION_PRINTER_DONT_PRINT_AUDIT_RESUMED:
				iAnswer = _iSerial_Add_FieldEx( (unsigned char *) EXT_PRINTER_DONT_PRINT_AUDIT_RESUMED, strlen( (const char*)EXT_PRINTER_DONT_PRINT_AUDIT_RESUMED), MESSAGE_TYPE_BINARY, true );
				break;
			case EXTENSION_PRINTER_PRINT_AUDIT_RZ:
				iAnswer = _iSerial_Add_FieldEx( (unsigned char *) EXT_PRINTER_PRINT_AUDIT_RZ, strlen( (const char*)EXT_PRINTER_PRINT_AUDIT_RZ), MESSAGE_TYPE_BINARY, true );
				break;
			case EXTENSION_PRINTER_PRINT_AUDIT_MONTH:
				iAnswer = _iSerial_Add_FieldEx( (unsigned char *) EXT_PRINTER_PRINT_AUDIT_MONTH, strlen( (const char*)EXT_PRINTER_PRINT_AUDIT_MONTH), MESSAGE_TYPE_BINARY, true );
				break;
			case EXTENSION_PRINTER_PRINT_AUDIT_RESUMED:
				iAnswer = _iSerial_Add_FieldEx( (unsigned char *) EXT_PRINTER_PRINT_AUDIT_RESUMED, strlen( (const char*)EXT_PRINTER_PRINT_AUDIT_RESUMED), MESSAGE_TYPE_BINARY, true );
				break;
		}
		iAnswer = _iSerial_Add_FieldEx( (unsigned char *) pstIn->szFechaInicial, strlen( (const char*)  pstIn->szFechaInicial ), MESSAGE_TYPE_ASCII, true );

		iAnswer = _iSerial_Add_FieldEx( (unsigned char *) pstIn->szFechaFinal, strlen( (const char*)  pstIn->szFechaFinal ), MESSAGE_TYPE_ASCII, false );
	}

	iAnswer = _iSerial_Send_Message();

	if( iAnswer != SERIAL_NO_ERROR )
		return iAnswer;

	while( _iSerial_Get_Comm_State() == SERIAL_STATE_BUSY );

	iAnswer = _iSerial_Get_Last_Comm_Error();

	if( pstOut != 0x00 && iAnswer == SERIAL_NO_ERROR )
	{
		iAnswer = _iSerial_Get_FieldEx( &pstOut->stFixedAnswer.usPrinterStatus, &iAnswerSize, ANSWER_FIELD_PRINTER_STATUS, ANSWER_TYPE_UNSIGNED_SHORT );
		iAnswer = _iSerial_Get_FieldEx( &pstOut->stFixedAnswer.usFiscalStatus, &iAnswerSize, ANSWER_FIELD_FISCAL_STATUS, ANSWER_TYPE_UNSIGNED_SHORT );
		iAnswer = _iSerial_Get_FieldEx( &pstOut->stFixedAnswer.usResponse, &iAnswerSize, ANSWER_FIELD_COMMAND_RESPONSE, ANSWER_TYPE_UNSIGNED_SHORT );

	}

	return iAnswer;
}

int CPrinterInformation::iPrinter_Information_RunAudit( void * vDataIn, void * vDataOut )
{
	PSTPRINTER_INFORMATION_PRINTER_RUN_AUDIT_IN	pstIn  = (PSTPRINTER_INFORMATION_PRINTER_RUN_AUDIT_IN)		vDataIn;
	PSTPRINTER_INFORMATION_PRINTER_RUN_AUDIT_OUT	pstOut = (PSTPRINTER_INFORMATION_PRINTER_RUN_AUDIT_OUT)	vDataOut;
	int iAnswer, iAnswerSize, iFieldCounter;

	_vSerial_Purge_Message();
	iAnswer = _iSerial_Add_FieldEx( (unsigned char *) CMD_PRINTER_INFORMATION_RUN_AUDIT, strlen( (const char*)CMD_PRINTER_INFORMATION_RUN_AUDIT), MESSAGE_TYPE_BINARY, true );

	if( pstIn )
	{
		switch( pstIn->iCommandExtension )
		{
			case EXTENSION_RESERVED:
			default:
				iAnswer = _iSerial_Add_FieldEx( (unsigned char *) EXT_RESERVED, strlen( (const char*)EXT_RESERVED), MESSAGE_TYPE_BINARY, false );
		}
	}
	else
		iAnswer = _iSerial_Add_FieldEx( (unsigned char *) EXT_RESERVED, strlen( (const char*)EXT_RESERVED), MESSAGE_TYPE_BINARY, false );

	iAnswer = _iSerial_Send_Message();

	if( iAnswer != SERIAL_NO_ERROR )
		return iAnswer;

	while( _iSerial_Get_Comm_State() == SERIAL_STATE_BUSY );

	iAnswer = _iSerial_Get_Last_Comm_Error();

	if( pstOut != 0x00 && iAnswer == SERIAL_NO_ERROR )
	{
		iAnswer = _iSerial_Get_FieldEx( &pstOut->stFixedAnswer.usPrinterStatus, &iAnswerSize, ANSWER_FIELD_PRINTER_STATUS, ANSWER_TYPE_UNSIGNED_SHORT );
		iAnswer = _iSerial_Get_FieldEx( &pstOut->stFixedAnswer.usFiscalStatus, &iAnswerSize, ANSWER_FIELD_FISCAL_STATUS, ANSWER_TYPE_UNSIGNED_SHORT );
		iAnswer = _iSerial_Get_FieldEx( &pstOut->stFixedAnswer.usResponse, &iAnswerSize, ANSWER_FIELD_COMMAND_RESPONSE, ANSWER_TYPE_UNSIGNED_SHORT );

		iFieldCounter = _iSerial_Get_Field_Counter();

		if( iFieldCounter > ANSWER_FIXED_FIELDS_COUNTER )
		{
			iAnswer = _iSerial_Get_FieldEx( &pstOut->szAuditData, &( pstOut->AuditDataSize ), ANSWER_FIELD_1, ANSWER_TYPE_BINARY );
			iAnswer = _iSerial_Get_FieldEx( &pstOut->szMoreData, &iAnswerSize, ANSWER_FIELD_2, ANSWER_TYPE_CHAR );
		}
	}

	return iAnswer;
}


int CPrinterInformation::iPrinter_Information_EndAudit( void * vDataIn, void * vDataOut )
{
	PSTPRINTER_INFORMATION_PRINTER_END_AUDIT_IN	pstIn  = (PSTPRINTER_INFORMATION_PRINTER_END_AUDIT_IN)		vDataIn;
	PSTPRINTER_INFORMATION_PRINTER_END_AUDIT_OUT	pstOut = (PSTPRINTER_INFORMATION_PRINTER_END_AUDIT_OUT)	vDataOut;
	int iAnswer, iAnswerSize;

	_vSerial_Purge_Message();
	iAnswer = _iSerial_Add_FieldEx( (unsigned char *) CMD_PRINTER_INFORMATION_END_AUDIT, strlen( (const char*)CMD_PRINTER_INFORMATION_END_AUDIT), MESSAGE_TYPE_BINARY, true );

	if( pstIn )
	{
		switch( pstIn->iCommandExtension )
		{
			case EXTENSION_RESERVED:
			default:
				iAnswer = _iSerial_Add_FieldEx( (unsigned char *) EXT_RESERVED, strlen( (const char*)EXT_RESERVED), MESSAGE_TYPE_BINARY, false );
		}
	}
	else
		iAnswer = _iSerial_Add_FieldEx( (unsigned char *) EXT_RESERVED, strlen( (const char*)EXT_RESERVED), MESSAGE_TYPE_BINARY, false );

	iAnswer = _iSerial_Send_Message();

	if( iAnswer != SERIAL_NO_ERROR )
		return iAnswer;

	while( _iSerial_Get_Comm_State() == SERIAL_STATE_BUSY );

	iAnswer = _iSerial_Get_Last_Comm_Error();

	if( pstOut != 0x00 && iAnswer == SERIAL_NO_ERROR )
	{
		iAnswer = _iSerial_Get_FieldEx( &pstOut->stFixedAnswer.usPrinterStatus, &iAnswerSize, ANSWER_FIELD_PRINTER_STATUS, ANSWER_TYPE_UNSIGNED_SHORT );
		iAnswer = _iSerial_Get_FieldEx( &pstOut->stFixedAnswer.usFiscalStatus, &iAnswerSize, ANSWER_FIELD_FISCAL_STATUS, ANSWER_TYPE_UNSIGNED_SHORT );
		iAnswer = _iSerial_Get_FieldEx( &pstOut->stFixedAnswer.usResponse, &iAnswerSize, ANSWER_FIELD_COMMAND_RESPONSE, ANSWER_TYPE_UNSIGNED_SHORT );
	}

	return iAnswer;
}




int CPrinterInformation::iPrinter_Information_CancelAudit( void * vDataIn, void * vDataOut )
{
	PSTPRINTER_INFORMATION_PRINTER_CANCEL_AUDIT_IN	pstIn  = (PSTPRINTER_INFORMATION_PRINTER_CANCEL_AUDIT_IN)		vDataIn;
	PSTPRINTER_INFORMATION_PRINTER_CANCEL_AUDIT_OUT	pstOut = (PSTPRINTER_INFORMATION_PRINTER_CANCEL_AUDIT_OUT)	vDataOut;
	int iAnswer, iAnswerSize;

	_vSerial_Purge_Message();
	iAnswer = _iSerial_Add_FieldEx( (unsigned char *) CMD_PRINTER_INFORMATION_CANCEL_AUDIT, strlen( (const char*)CMD_PRINTER_INFORMATION_CANCEL_AUDIT), MESSAGE_TYPE_BINARY, true );

	if( pstIn )
	{
		switch( pstIn->iCommandExtension )
		{
			case EXTENSION_RESERVED:
			default:
				iAnswer = _iSerial_Add_FieldEx( (unsigned char *) EXT_RESERVED, strlen( (const char*)EXT_RESERVED), MESSAGE_TYPE_BINARY, false );
		}
	}
	else
		iAnswer = _iSerial_Add_FieldEx( (unsigned char *) EXT_RESERVED, strlen( (const char*)EXT_RESERVED), MESSAGE_TYPE_BINARY, false );

	iAnswer = _iSerial_Send_Message();

	if( iAnswer != SERIAL_NO_ERROR )
		return iAnswer;

	while( _iSerial_Get_Comm_State() == SERIAL_STATE_BUSY );

	iAnswer = _iSerial_Get_Last_Comm_Error();

	if( pstOut != 0x00 && iAnswer == SERIAL_NO_ERROR )
	{
		iAnswer = _iSerial_Get_FieldEx( &pstOut->stFixedAnswer.usPrinterStatus, &iAnswerSize, ANSWER_FIELD_PRINTER_STATUS, ANSWER_TYPE_UNSIGNED_SHORT );
		iAnswer = _iSerial_Get_FieldEx( &pstOut->stFixedAnswer.usFiscalStatus, &iAnswerSize, ANSWER_FIELD_FISCAL_STATUS, ANSWER_TYPE_UNSIGNED_SHORT );
		iAnswer = _iSerial_Get_FieldEx( &pstOut->stFixedAnswer.usResponse, &iAnswerSize, ANSWER_FIELD_COMMAND_RESPONSE, ANSWER_TYPE_UNSIGNED_SHORT );
	}

	return iAnswer;
}



