#include <stdio.h>
#include <string.h>
#include <time.h>

#include "LogUtils.h"
#ifndef __linux__
#include <windows.h>
#else
#include <malloc.h>
extern "C" int zipmain(int, char**);
#endif


Logger::Logger( )
{
	szPath[0]=0;
}

void Logger::SetPath( char* szUserPath )
{
	FILE *fLogFile;
	// Get Date and Time
	time_t ltime;
    	struct tm *today;
	time( &ltime );
    	today = localtime( &ltime );
	//Store currentDay
	iDay = today->tm_mday;

	// Set the path of log Files
	strncpy( szPath, szUserPath, sizeof(szPath) );
	szPath[ sizeof(szPath) - 1 ] = 0;

	CompactAllFiles();
	GenerateFileName( szLogFileName );

	fLogFile = OpenFile( szLogFileName );
	if( fLogFile )
	{
		//fputs( "\n", fLogFile);
		CloseFile( fLogFile );
	}
	else
	{
		szPath[0]=0;
	}
}


void Logger::LogLine( char* szLine, char chAction )
{
	FILE *fLogFile;
	// Check if the day changed and change file log too
	time_t ltime;
    struct tm *today;
	time( &ltime );
    today = localtime( &ltime );

	if( szPath[0]==0 ) return;

	// If no log is needed, stop all
	if( chAction == LOGGER_NO_LOG )
		return;

	// Check if the day changed and change file log too
	if( iDay != today->tm_mday )
	{
		iDay = today->tm_mday;
		CompactAllFiles();
		GenerateFileName( szLogFileName );
	}

	if( chAction == LOGGER_LOG_NOW )
		fLogFile = OpenFile( szLogFileName );
	else
		fLogFile = OpenFile( LOGGER_TEMP_FILE );

	if( fLogFile )
	{
		WriteLine( fLogFile, szLine );
		CloseFile( fLogFile );
	}
}

void Logger::LogData( char * szDirection, unsigned char* szBuffer, int iSize, char chAction )
{
	char *pszText;

	pszText = (char*) malloc( 1024*20 );
	if( pszText == NULL )
		return;

	sprintf( pszText, "%s\n", szDirection );
	ConvertDatatoText( pszText, szBuffer, iSize );
	LogLine( pszText, chAction );

	free( pszText );
}


void Logger::FlushTemp( void )
{
	char szNameTemp[1050];
	
	if( szPath[0]==0 ) return;

	sprintf( szNameTemp, "%s%s.txt", szPath, LOGGER_TEMP_FILE );
	remove( szNameTemp );
}

void Logger::LogTemp( void )
{
	// Move the data from TempFile to LogFile
	FILE *fTempFile, *fLogFile;
	char szNameTempFile[1050], szNameLogFile[1050];
	char szBuff[1000];
	int  iSize;

	if( szPath[0]==0 ) return;

	sprintf( szNameLogFile,  "%s%s.txt", szPath, szLogFileName );
	sprintf( szNameTempFile, "%s%s.txt", szPath, LOGGER_TEMP_FILE );

	fLogFile  = fopen(szNameLogFile, "at");
	fTempFile = fopen(szNameTempFile, "rt");

	// If file cannot be oppened, return without action
	if( fLogFile==NULL || fTempFile==NULL )
		return;

	// Write all data from temp to log
    while( iSize=(int)fread(szBuff, 1, 1000, fTempFile) )
	{
		fwrite( szBuff, 1, iSize, fLogFile );
	}

	fclose( fLogFile );
	fclose( fTempFile );

	FlushTemp();
}

FILE * Logger::OpenFile( char *szFileName )
{
	FILE *fLogFile;
	char szFullFileName[1500];
	time_t ltime;
	struct tm *today;
	time( &ltime );
    	today = localtime( &ltime );
	char szLine[1500];

	sprintf( szFullFileName, "%s%s.txt", szPath, szFileName );

	// If file not exists, create it and write an header on it
	if( !fileexist(szFileName) )
	{
		fLogFile = fopen( szFullFileName, "at" );
		if( !strstr( szFullFileName, LOGGER_TEMP_FILE ) && fLogFile!=NULL )
		{
			sprintf( szLine, "Arquivo criado em %2.2d/%2.2d/%4.4d \n",
					 today->tm_mday, today->tm_mon+1, today->tm_year+1900 );
			fputs( szLine, fLogFile );
		}
	}
	else
	{
		fLogFile = fopen( szFullFileName, "at" );
	}

	return fLogFile;
}

void Logger::CloseFile( FILE *fLogFile )
{
	fclose( fLogFile );
}

void Logger::CompactFile( char *szFileName )
{
	char szTextFile[50], szFileIn[1050], szFileOut[1050];

	sprintf( szFileIn,  "%s%s.txt", szPath, szFileName );
	sprintf( szFileOut, "%s%s.zip", szPath, szFileName );
	sprintf( szTextFile,"%s.txt", szFileName );

	#ifdef __linux__
		// for linux
		char szParam0[1500];
		char szParam1[1500];
		char szParam2[1500];
		char szParam3[1500];
		char *pszParam[4];

		sprintf(szParam0, "zip");
		sprintf(szParam1, "-q");
		sprintf(szParam2, szFileOut);
		sprintf(szParam3, szFileIn);

		pszParam[0]=szParam0;
		pszParam[1]=szParam1;
		pszParam[2]=szParam2;
		pszParam[3]=szParam3;

		zipmain(4, pszParam);
	#else 
		// for windows
		/*HZIP hzip;
		hzip = CreateZip( szFileOut, 0, ZIP_FILENAME );
		ZipAdd(hzip, szTextFile, szFileIn, 0, ZIP_FILENAME );
		CloseZip( hzip );*/
	#endif

}

void Logger::EraseFiles( void )
{
	int iDayAux;
	char szNameTemp[1050];

	// Loop all days and compact files not from this day. Erase text equivalent file
	for(iDayAux=1; iDayAux<=31; iDayAux++)
	{
		if( iDayAux!= iDay ) // Do only for days that is not today
		{
			sprintf( szNameTemp, "eplog_%02d", iDayAux );
			if( fileexist(szNameTemp) )// Do only if the text file exixts
			{
				sprintf( szNameTemp, "%seplog_%02d.txt", szPath, iDayAux );
				remove( szNameTemp );
			}
		}
	}	
}

void Logger::GenerateFileName( char *szFileName )
{
	// Get Date and Time
	time_t ltime;
    struct tm *today;
	time( &ltime );
    today = localtime( &ltime );

	// Generate file name based on month day
	sprintf( szFileName, "eplog_%02d", today->tm_mday );
}

void Logger::CompactAllFiles( void )
{
	int iDayAux;
	char szNameTemp[50];

	// Loop all days and compact files not from this day. Erase text equivalent file
	for(iDayAux=1; iDayAux<=31; iDayAux++)
	{
		if( iDayAux!= iDay ) // Do only for days that is not today
		{
			sprintf( szNameTemp, "eplog_%02d", iDayAux );
			if( fileexist(szNameTemp) )// Do only if the text file exixts
			{
				CompactFile( szNameTemp );
			}
		}
	}
	EraseFiles( );
}

void Logger::WriteLine( FILE *fLogFile, char *szLine )
{
	// Get Date and Time
	time_t ltime;
    struct tm *today;
	char szDateTime[50];

	time( &ltime );
    today = localtime( &ltime );

	sprintf( szDateTime, "%02.2d:%02.2d:%02.2d  ", today->tm_hour, today->tm_min, today->tm_sec );
	
	// Log Information
    fputs( szDateTime, fLogFile );
	fputs( szLine, fLogFile );
	fputs( "\n", fLogFile );
}

void Logger::ConvertDatatoText( char *szText, unsigned char *szBuffer, int iSize )
{
	//char szTemp[1024];
	char szHexByte[4];
	int  iPosition, iLineSize, iExtra;

	long lCounter = 0;
	char szCounter[10];
	char szTemp[100];
	int  iTextSize;

	/* Initialization */
	iPosition = iLineSize = iExtra = 0;
	iTextSize = iSize - 1;
	sprintf( szTemp, " " );

	sprintf( szHexByte, "\t" );
	strcat( szText, szHexByte );

	/* Insert the binary data header */
	sprintf( szCounter, "%3.3ld: ", lCounter );
	strcat( szText, szCounter );

	if( strstr( szText, "LLI" ) && iSize>8 )
	{
		strcat( szText, "02 " );
		iExtra = 1;
		iLineSize++;

		/* Insert the ASCII code */
		sprintf( szHexByte, "." );
		strcat( szTemp, szHexByte );
		iTextSize++;
	}

	while( iPosition < iSize )
	{
		sprintf( szHexByte, "%2.2X ", szBuffer[iPosition] );
		strcat( szText, szHexByte );

		/* Insert the ASCII code */
		if( ( szBuffer[iPosition] >= 0x20 ) &&
			( szBuffer[iPosition] <= 0x7E ) )
			sprintf( szHexByte, "%c", szBuffer[iPosition] );
		else
			sprintf( szHexByte, "." );

		strcat( szTemp, szHexByte );
		iLineSize++;
		iPosition++;

		// Break line after 16 characters
		if( ( iLineSize > 15 ) && ( iLineSize < (iSize+iExtra) ) )
		{
			iLineSize = 0;

			/* Place the ASCII data after binary data */
			strcat( szText, szTemp );
			sprintf( szTemp, " " );

			sprintf( szHexByte, "\n\t" );
			strcat( szText, szHexByte );

			/* Insert the line header */
			lCounter += 16;
			sprintf( szCounter, "%3.3ld: ", lCounter );
			strcat( szText, szCounter );
		}
	}

	/* Last ASCII data positioning */
	for( lCounter = 1; lCounter < ( 16-(iTextSize%16) ); lCounter++ )
	{
		sprintf( szHexByte, "   " );
		strcat( szText, szHexByte );
	}

	strcat( szText, szTemp );
}


bool Logger::fileexist(char *szName)
{
	FILE *ffile;
	bool bfileexist;
	char szFullFileName[1500];

	sprintf( szFullFileName, "%s%s.txt", szPath, szName );

	ffile = fopen ( szFullFileName, "rt" );

	bfileexist = ffile?true:false;

	if(bfileexist) fclose(ffile);

	return bfileexist;
}
