/***********************************************************************/
/* ECFAFRAC.cpp : Defines the initialization routines for the DLL.     */
/***********************************************************************/
/* Revision History:                                                   */
/*                                                                     */
/* Date        Nummber    Revision Name     Author Name                */
/* 23/05/2003    1.0      Initial Version   Marcus Vinicius Scolastici */
/***********************************************************************/

#include "stdafx.h"
#include "utils.h"
#include "serial.h"

#include "EpsonFiscalProtocol.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif

/*****************************************************************/
/*	Note!                                                        */
/*                                                               */
/*		If this DLL is dynamically linked against the MFC        */
/*		DLLs, any functions exported from this DLL which         */
/*		call into MFC must have the AFX_MANAGE_STATE macro       */
/*		added at the very beginning of the function.             */
/*                                                               */
/*		For example:                                             */
/*                                                               */
/*		extern "C" BOOL PASCAL EXPORT ExportedFunction()         */
/*		{                                                        */
/*			AFX_MANAGE_STATE(AfxGetStaticModuleState());         */
/*			// normal function body here                         */
/*		}                                                        */
/*                                                               */
/*		It is very important that this macro appear in each      */
/*		function, prior to any calls into MFC.  This means that  */
/*		it must appear as the first statement within the         */
/*		function, even before any object variable declarations   */
/*		as their constructors may generate calls into the MFC    */
/*		DLL.												     */
/*                                                               */
/*		Please see MFC Technical Notes 33 and 58 for additional  */
/*		details.                                                 */
/*****************************************************************/

DWORD OpenSerialPort( WORD sSerialPort, DWORD iBaudRate )
{
	STSERIAL_CONFIG stSerial_Config;
	DWORD iReturn;

	stSerial_Config.iBaud_Rate = iBaudRate;
	stSerial_Config.sComm_Port = sSerialPort;
	stSerial_Config.sData_Bits = 8;
	stSerial_Config.sParity = 'n';
	stSerial_Config.sStop_Bits = 1;

	iReturn = _iSerial_Open_Port( &stSerial_Config );

	if( iReturn >= ERROR_SERIAL_INTERNAL_ERROR )
		return ERROR_SERIAL_INTERNAL_ERROR;
	
	return iReturn;
}

DWORD CloseSerialPort( void )
{
	DWORD iReturn;

	iReturn = _iSerial_Close_Port();

	if( iReturn >= ERROR_SERIAL_INTERNAL_ERROR )
		return ERROR_SERIAL_INTERNAL_ERROR;

	return iReturn;
}

DWORD SendSerialMessage( void )
{
	DWORD iReturn;

	iReturn = _iSerial_Send_Message();

	if( iReturn >= ERROR_SERIAL_INTERNAL_ERROR )
		return ERROR_SERIAL_INTERNAL_ERROR;

	return SERIAL_NO_ERROR;
}

DWORD ResendSerialMessage( void )
{
	DWORD iReturn;

	iReturn = _iSerial_Resend_Message();

	if( iReturn >= ERROR_SERIAL_INTERNAL_ERROR )
		return ERROR_SERIAL_INTERNAL_ERROR;

	return iReturn;
}

DWORD AddMessageField( BYTE * szField, DWORD iFieldLength )
{
	DWORD iReturn;

	iReturn = _iSerial_Add_Field( (unsigned char*) szField, iFieldLength );
 
	if( iReturn >= ERROR_SERIAL_INTERNAL_ERROR )
		return ERROR_SERIAL_INTERNAL_ERROR;

	return iReturn;
}

DWORD AddMessageFieldEx( BYTE * szField, DWORD iFieldLength, DWORD uiFieldType, bool bSeparator )
{
	DWORD iReturn;

	iReturn = _iSerial_Add_FieldEx( (unsigned char *) szField, iFieldLength, uiFieldType, bSeparator );

	if( iReturn >= ERROR_SERIAL_INTERNAL_ERROR )
		return ERROR_SERIAL_INTERNAL_ERROR;

	return iReturn;
}

void PurgeMessage( void )
{
	_vSerial_Purge_Message();
}

DWORD GetFieldCounter( void )
{	
	return _iSerial_Get_Field_Counter();
}

DWORD GetCommunicationState( void )
{
	return _iSerial_Get_Comm_State();
}

DWORD GetMessageField( BYTE *szAnswer, DWORD *iAnswerSize, DWORD iAnswerField )
{	
	DWORD iReturn;
	
	iReturn = _iSerial_Get_Field( szAnswer, (int *) iAnswerSize, iAnswerField );

	if( iReturn >= ERROR_SERIAL_INTERNAL_ERROR )
		return ERROR_SERIAL_INTERNAL_ERROR;

	return iReturn;
}

DWORD GetMessageFieldEx( void *vAnswer, DWORD *iAnswerSize, DWORD iAnswerField, DWORD iAnswerType )
{	
	DWORD iReturn;

	iReturn = _iSerial_Get_FieldEx(vAnswer, (int *) iAnswerSize, iAnswerField, iAnswerType );

	if( iReturn >= ERROR_SERIAL_INTERNAL_ERROR )
		return ERROR_SERIAL_INTERNAL_ERROR;

	return iReturn;
}

DWORD GetLastCommError( void )
{
	return _iSerial_Get_Last_Comm_Error();
}

DWORD   GetSentFrame( BYTE * szBuffer, DWORD * iBufferLength )
{
	return _iSerial_Get_Sent_Frame( (unsigned char *) szBuffer, (int *) iBufferLength );
}

DWORD   GetReceivedFrame( BYTE * szBuffer , DWORD * iBufferLength )
{
	return _iSerial_Get_Received_Frame( (unsigned char*) szBuffer, (int *) iBufferLength );
}
