#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <windows.h>
#include <Wincrypt.h>
#include "TaurusInterface.h"
#include "CTaurusInterface.h"
#include "functions.h"
#include "options.h"
#include "extensions.h"
#include "structsIn.h"
#include "structsOut.h"
#include "serial.h"
#include "utils.h"

CTaurusInterfaceApp::CTaurusInterfaceApp()
{
	char chLoggerAction;
	DWORD dwLogAction;

	dwCommunicationAnswer = 0;
	dwPrinterStatus       = 0;
	dwFiscalStatus        = 0;
	dwCommandResponse     = 0;

	iComSpeed=1;
	iComPort=9600;

	// Get log action from register
	dwLogAction=0;
	vCheckLogFlag(&dwLogAction);
	if((dwLogAction>=0) && ((dwLogAction<=2) || (dwLogAction==1000) || (dwLogAction==2000)) )
	{
		// EPSON_Sys_Log("",dwLogAction);
		CHAR szLogLine[1050];
		CHAR szPath[1024];

		strcpy(szPath,"");
		dwEpsonLogPath(szPath);

		chLoggerAction = (char) dwLogAction;
		clsLog.SetPath( (char*) szPath );

		if( dwLogAction != 1000 && dwLogAction != 2000 ) // This Action is equal "1" or 2, but do not save message "LogBeggin"
		{
			// Log HighLevel Information Input
			sprintf( szLogLine, "Log Activado (%d) - Biblioteca InterfaceEpson.dll ver %s", dwLogAction, DLLVERSION );
			clsLog.LogLine( szLogLine, dwLogAction?1:0 );
			// End of Log HighLevel Information Input
		}
		else
			chLoggerAction = (char) (dwLogAction/1000);

		_vSerial_Set_Log( (char*)szPath, (char) chLoggerAction );

	}

	return;
}

VOID CTaurusInterfaceApp::vSetInternalState( DWORD dwPrinter, DWORD dwFiscal, DWORD dwCommand )
{
	dwPrinterStatus       = dwPrinter;
	dwFiscalStatus        = dwFiscal;
	dwCommandResponse     = dwCommand;
}

DWORD CTaurusInterfaceApp::dwOpenSerialPort(  DWORD dwBaudRate = 9600,
											                        WORD  wCommPort  = 1,
					  					                        WORD  wDataBits  = 8,
											                        WORD  wParity	   = 'n',
											                        WORD  wStopBits  = 1 )
{
	STSERIAL_CONFIG		stSerialConfig;

	stSerialConfig.iBaud_Rate = dwBaudRate;
	stSerialConfig.sComm_Port = wCommPort;
	stSerialConfig.sData_Bits = wDataBits;
	stSerialConfig.sParity    = wParity;
	stSerialConfig.sStop_Bits = wStopBits;

  vSetInternalState( 0x0000, 0x0000, 0x0000 );

  dwCommunicationAnswer = _iSerial_Open_Port( &stSerialConfig );
  if( dwCommunicationAnswer != SERIAL_NO_ERROR )
	{
		return ERROR;
	}

	return SUCCESS;
}

DWORD CTaurusInterfaceApp::dwCloseSerialPort( VOID )
{
	vSetInternalState( 0x0000, 0x0000, 0x0000 );

	dwCommunicationAnswer = _iSerial_Close_Port();
	if( dwCommunicationAnswer != SERIAL_NO_ERROR )
	{
		return ERROR;
	}

	return SUCCESS;
}

DWORD CTaurusInterfaceApp::dwVerificarConexion(char * pszPort)
{
	STPRINTER_INFORMATION_PRINTER_STATUS_IN	stIn;
	STPRINTER_INFORMATION_PRINTER_STATUS_OUT	stOut;
	DWORD	dwSpeedArray[3] = { 9600, 19200, 38400 };
	INT	iCounter;
	DWORD	dwAnswer;

	if ( pszPort == NULL )
		return ERROR;

	/* Initializing Variables */
	memset( &stIn, 0x00, sizeof( stIn ) );
	memset( &stOut, 0x00, sizeof( stOut ) );

	/* Preparing command */
	stIn.iCommandExtension = EXTENSION_RESERVED;

	/* Preparing Interface */
	clsFunctionSelector.dwAddCommandType( FUNCTION_SELECTOR_PRINTER_INFORMATION_GROUP );
	clsFunctionSelector.dwAddCommandDescription( OPTION_GROUP_PRINTER_INFORMATION_GET_PRINTER_STATUS );
	clsFunctionSelector.dwAddInputData( &stIn );
	clsFunctionSelector.dwAddOutputData( &stOut );

	iComPort = atoi( (char *)pszPort);

	for( iCounter = 0; iCounter < 3; iCounter++ )
	{
		dwAnswer = dwOpenSerialPort( dwSpeedArray[iCounter], iComPort ,8 ,'n' ,1 );
		if (dwAnswer == SUCCESS)
		{
			/* Get Printer Status */
			dwAnswer = clsFunctionSelector.dwStartProcess();
			dwCloseSerialPort();
			if (dwAnswer == SUCCESS)
			{
				iComSpeed = dwSpeedArray[iCounter];
				return SUCCESS;
			}
		}
	}

	return ERROR;
}

DWORD CTaurusInterfaceApp::dwLeerLibroMensual( char * pszFechaDesde, char * pszFechaHasta,
                                               char * pszNombreArchivoSalida )
{
	DWORD	dwAnswer;

  //inicializar totales mensuales
  memset( &salesBookMonthTotals, 0, sizeof( tSalesBookTotals ) );

  //obtener rango de cierres Z
  int FirstZNum = 0;
  int LastZNum = 0;

	dwAnswer = dwOpenSerialPort( iComSpeed, iComPort ,8 ,'n' ,1 );
	if ( dwAnswer != SUCCESS )
	{
		dwCloseSerialPort();
		return ERROR;
	}

  dwAnswer = dwGetInfoBtwnDates(pszFechaDesde, pszFechaHasta, &FirstZNum, &LastZNum);
  if (dwAnswer != SUCCESS)
  {
  	dwCloseSerialPort();
    return ERROR;
  }

  //leer Libro diario para cada cierre Z
  FILE * pDestMonthFile = fopen(pszNombreArchivoSalida,"wb+");
	if ( pDestMonthFile == NULL )
  {
  	dwCloseSerialPort();
		return ERROR;
  }

  FILE * pTempMonthFile = tmpfile();
  if ( pTempMonthFile == NULL )
  {
    fclose(pDestMonthFile);
  	dwCloseSerialPort();
    return ERROR;
  }

  int i;
  char temp[20];
  for ( i = FirstZNum; i <= LastZNum; i++ )
  {
    dwAnswer = dwLeerZ( pTempMonthFile, _itoa( i, temp, 10) );
    if (dwAnswer != SUCCESS)
    {
  	  fclose(pTempMonthFile);
      fclose(pDestMonthFile);
    	dwCloseSerialPort();
      return ERROR;
    }
  }

  //grabar libro mensual
  if ( dwSaveMonthBook(pDestMonthFile, pTempMonthFile, salesBookMonthTotals) != SUCCESS )
  {
	  fclose(pTempMonthFile);
    fclose(pDestMonthFile);
  	dwCloseSerialPort();
    return ERROR;
  }

	fclose(pTempMonthFile);
	fclose(pDestMonthFile);
	dwCloseSerialPort();

	return SUCCESS;
}

bool CTaurusInterfaceApp::GetNextField( FILE	*srcFile, char * buffer, int bufsize )
{
  char charNow;

  while ( !feof( srcFile ) )
  {
    charNow = fgetc(srcFile);

    // ignorar caracteres
    if ( ( charNow == '\n' ) || ( charNow == '\0' ) )
    {
      continue;
    }

    //verificar fin de campo
    if ( charNow == '|' )
    {
      // Leer siguiente '|'
      charNow = fgetc(srcFile);
      break;
    }

    //Verificar llenado del buffer de salida (reservar lugar para '\0' final)
    if ( bufsize == 1 )
    {
      //Siempre debe haber espacio en el buffer de salida para cualquier campo
      return false;
    }

    //Guardar caracter
    *buffer = charNow;
    buffer++;
    bufsize--;
  }

  *buffer = '\0';
	return true;
}

void CTaurusInterfaceApp::AcumSalesBookTotals( tSalesBookTotals & totals, tSalesBookTotals & src )
{
  totals.CantidadRegistros      += src.CantidadRegistros;
  totals.MontoTotalArchivo      += src.MontoTotalArchivo;
  totals.ITBISTotalArchivo      += src.ITBISTotalArchivo;
  totals.MontoConsFinal         += src.MontoConsFinal;
  totals.MontoCredFiscal        += src.MontoCredFiscal;
  totals.MontoNotaCredConsFinal += src.MontoNotaCredConsFinal;
  totals.MontoNotaCredCredFisc  += src.MontoNotaCredCredFisc;
  totals.ITBISConsFinal         += src.ITBISConsFinal;
  totals.ITBISCredFiscal        += src.ITBISCredFiscal;
  totals.ITBISNotaCredConsFinal += src.ITBISNotaCredConsFinal;
  totals.ITBISNotaCredCredFisc  += src.ITBISNotaCredCredFisc;
}

bool CTaurusInterfaceApp::ReadDailyBookLine( FILE	*srcFile )
{
  //interpretar ciertos datos
  tSalesBookTotals srcBookTotals;
  memset( &srcBookTotals, 0, sizeof( tSalesBookTotals ) );

  __int64 * TempAmount;
  int FldCount = 1; // Campo ID ya fue leido y parseado
  char Field[128];

  while ( !feof( srcFile ) )
  {
    // leer solo los campos de la linea correspondiente
    if ( FldCount == 25 )
      break;

    if ( !GetNextField( srcFile, Field, 128 ) )
    {
		  return false;
    }
    FldCount++;

    // si el campo esta vacio => ignorarlo
    if ( strlen( Field ) == 0 )
      continue;

    TempAmount = NULL;

    switch ( FldCount )
    {
      case 4: //Numero de registros
        srcBookTotals.CantidadRegistros = atoi( Field );
        break;
      case 5: //Monto total
        TempAmount = &srcBookTotals.MontoTotalArchivo;
        break;
      case 6: //Monto ITBIS
        TempAmount = &srcBookTotals.ITBISTotalArchivo;
        break;
      case 7: //Monto venta consumidor final
        TempAmount = &srcBookTotals.MontoConsFinal;
        break;
      case 8: //Monto ITBIS consumidor final
        TempAmount = &srcBookTotals.ITBISConsFinal;
        break;
      case 10: //Monto venta credito fiscal
        TempAmount = &srcBookTotals.MontoCredFiscal;
        break;
      case 11: //Monto ITBIS credito fiscal
        TempAmount = &srcBookTotals.ITBISCredFiscal;
        break;
      case 13: //Monto nota credito consumidor final
        TempAmount = &srcBookTotals.MontoNotaCredConsFinal;
        break;
      case 14: //Monto ITBIS nota credito consumidor final
        TempAmount = &srcBookTotals.ITBISNotaCredConsFinal;
        break;
      case 16: //Monto nota credito credito fiscal
        TempAmount = &srcBookTotals.MontoNotaCredCredFisc;
        break;
      case 17: //Monto ITBIS nota credito credito fiscal
        TempAmount = &srcBookTotals.ITBISNotaCredCredFisc;
        break;
      default:
        // Ignorar campos
        break;
    }

    if ( TempAmount != NULL )
    {
      char * dec = Field;
    
      //reemplazar '.' por '\0' y obtener string decimales
      while ( dec )
      {
        if ( *dec == '.' )
        {
          *dec = '\0';
          dec++;
          break;
        }
        dec++;
      }

      *TempAmount = _atoi64( Field ) * 100;
      *TempAmount += _atoi64( dec );
    }
  }

  //Acumular totales mensuales
  AcumSalesBookTotals( salesBookMonthTotals, srcBookTotals );

  return true;
}

bool CTaurusInterfaceApp::ReadTransactionLine( FILE	*srcFile )
{
  int FldCount = 1; // Campo ID ya fue leido y parseado
  char Field[128];

  while ( !feof( srcFile ) )
  {
    // leer solo los campos de la linea correspondiente
    if ( FldCount == 28 )
      break;

    if ( !GetNextField( srcFile, Field, 128 ) )
    {
		  return false;
    }
    FldCount++;

    // Ignorar todos los campos
  }

  return true;
}

DWORD CTaurusInterfaceApp::dwReadDailyBook( FILE * outDlyBooksFile, char * pszFile )
{
  //Abrir archivo, interpretar ciertos datos, acumularlos, appendearlo al final de archivo temporal destino
	FILE * pSrcDlyBook = fopen( pszFile, "rb+" );
	if ( pSrcDlyBook == NULL )
  {
		return ERROR;
  }
   
  char Field[2];
  bool result;
  while ( true )
  {
    if ( !GetNextField( pSrcDlyBook, Field, 2 ) )
    {
      fclose(pSrcDlyBook);
		  return ERROR;
    }

    // detectar fin de archivo
    if ( feof( pSrcDlyBook ) )
    {
      break;
    }

    // leer campo de id
    switch ( Field[0] )
    {
      case '1':
        result = ReadDailyBookLine( pSrcDlyBook );
        break;
      case '2':
        result = ReadTransactionLine( pSrcDlyBook );
        break;
      case '3':
        // Si se encuentra una lnea de libro mensual => se esta leyendo un archivo erroneo
      default:
        fclose(pSrcDlyBook);
		    return ERROR;
    }
    if ( !result )
    {
      fclose(pSrcDlyBook);
		  return ERROR;
    }
  }

  //appendear archivo diario al final de archivo mensual temporal destino
  FileAppend( outDlyBooksFile, pSrcDlyBook );

  fclose(pSrcDlyBook);

  return SUCCESS;
}


DWORD CTaurusInterfaceApp::dwGenerarLibroMensual(char * pszDirectorio, char * pszNombreArchivoSalida)
{
  FILE * pDestMonthFile = fopen(pszNombreArchivoSalida,"wb+");
	if ( pDestMonthFile == NULL )
		return ERROR;

  //leer Libro diario para cada cierre Z
  FILE * pTempMonthFile = tmpfile();
  if ( pTempMonthFile == NULL )
    return ERROR;

  //inicializar totales mensuales
  memset( &salesBookMonthTotals, 0, sizeof( tSalesBookTotals ) );

  //por cada archivo del directorio con formato LV*
  char SearchPattern[ MAX_PATH + 5 ];
  char FileNow[ MAX_PATH + 1 ];
  WIN32_FIND_DATA ffd;
  HANDLE hFind = INVALID_HANDLE_VALUE;
 
  if ( strlen( pszDirectorio ) > MAX_PATH )
    return ERROR;

  strcpy( SearchPattern, pszDirectorio );
  strcat( SearchPattern, "\\LV*" );

  hFind = FindFirstFile(SearchPattern, &ffd);
  if ( INVALID_HANDLE_VALUE == hFind ) 
    return ERROR;
   
  do
  {
    //verificar que el archivo no sea un libro mensual
    if ( ffd.cFileName[2] == 'M' )
      continue;
    strcpy( FileNow, pszDirectorio );
    strcat( FileNow, "\\" );
    strcat( FileNow, ffd.cFileName );
    dwReadDailyBook( pTempMonthFile, FileNow );
  } while ( FindNextFile(hFind, &ffd ) != 0 );

  if (GetLastError() != ERROR_NO_MORE_FILES) 
    return ERROR;

  FindClose(hFind);

  //grabar libro mensual
  if ( dwSaveMonthBook(pDestMonthFile, pTempMonthFile, salesBookMonthTotals) != SUCCESS )
  {
  	fclose(pTempMonthFile);
	  fclose(pDestMonthFile);
    return ERROR;
  }

	fclose(pTempMonthFile);
	fclose(pDestMonthFile);

	return SUCCESS;
}

DWORD CTaurusInterfaceApp::dwLeerZ( FILE * outDlyFile, char * pszZNumber )
{
	DWORD	dwAnswer;

	dwAnswer = dwStartAuditZ(pszZNumber, EXTENSION_PRINTER_DONT_PRINT_AUDIT_RZ);
	if (dwAnswer != SUCCESS)
	{
		dwAnswer = dwVerifyCancelAudit();
		if (dwAnswer != SUCCESS)
		{
			return ERROR;
		}

		dwAnswer = dwStartAuditZ(pszZNumber, EXTENSION_PRINTER_DONT_PRINT_AUDIT_RZ);
		if (dwAnswer != SUCCESS)
		{
			return ERROR;
		}
	}

	dwAnswer = dwWriteBinAuditFile();
	if (dwAnswer != SUCCESS)
	{
		return ERROR;
	}

	dwAnswer = dwEndAudit();
	if (dwAnswer != SUCCESS)
	{
		return ERROR;
	}

	dwAnswer = dwParseBinAuditFile( outDlyFile, pszZNumber );
	if (dwAnswer != SUCCESS)
	{
		return ERROR;
	}

	return SUCCESS;
}

DWORD CTaurusInterfaceApp::dwLeerLibroZ(char * pszZNumber, char * pszNombreArchivoSalida)
{
	DWORD	dwAnswer;

	dwAnswer = dwOpenSerialPort( iComSpeed, iComPort ,8 ,'n' ,1 );
	if (dwAnswer != SUCCESS)
	{
		dwCloseSerialPort();
		return ERROR;
	}

  FILE * outDlyFile = fopen(pszNombreArchivoSalida,"wb+");
  if ( outDlyFile == NULL )
    return ERROR;

	dwAnswer = dwLeerZ( outDlyFile, pszZNumber );
	if (dwAnswer != SUCCESS)
	{
   	fclose(outDlyFile);
  	dwCloseSerialPort();
		return ERROR;
	}

  fclose(outDlyFile);
	dwCloseSerialPort();

	return SUCCESS;
}

DWORD CTaurusInterfaceApp::dwLeerLibroDiario(char * pszFecha, char * pszNombreArchivoSalida)
{
	DWORD	dwAnswer;

  //obtener rango de cierres Z
  int FirstZNum = 0;
  int LastZNum = 0;

	dwAnswer = dwOpenSerialPort( iComSpeed, iComPort ,8 ,'n' ,1 );
	if ( dwAnswer != SUCCESS )
	{
		dwCloseSerialPort();
		return ERROR;
	}

  dwAnswer = dwGetInfoBtwnDates(pszFecha, pszFecha, &FirstZNum, &LastZNum);
  if (dwAnswer != SUCCESS)
  {
  	dwCloseSerialPort();
    return ERROR;
  }

  //leer Libro diario para cada cierre Z
  FILE * pDestDlyFile = fopen(pszNombreArchivoSalida,"wb+");
	if ( pDestDlyFile == NULL )
  {
  	dwCloseSerialPort();
		return ERROR;
  }

  int i;
  char temp[20];
  for ( i = FirstZNum; i <= LastZNum; i++ )
  {
    dwAnswer = dwLeerZ( pDestDlyFile, _itoa( i, temp, 10) );
    if (dwAnswer != SUCCESS)
    {
      fclose(pDestDlyFile);
    	dwCloseSerialPort();
      return ERROR;
    }
  }

	fclose(pDestDlyFile);
	dwCloseSerialPort();

	return SUCCESS;
}

DWORD CTaurusInterfaceApp::dwParseBinAuditFile( FILE * outDlyFile, char * pszZNumber )
{
  tSalesBookTransaction salesBookTransaction;
  char	szTempFileName[1024];

  memset( szTempFileName, 0, sizeof(szTempFileName) );
	iGetEpsonPath(szTempFileName);
	strcat( szTempFileName, "temp_audit.tmp" );

	FILE * srcBinFile = fopen(szTempFileName,"rb+");
	if ( srcBinFile == NULL )
		return ERROR;
   
  //Inicilizar datos header auditoria
  memset( &AuditHeaderRecord, 0, sizeof(tAuditHeaderRecord) );
  memset( &AuditJournalInfoRecord, 0, sizeof(tAuditJournalInfoRecord) );

  //Grabar transacciones en un archivo temporal
  FILE * tmpTransFile = tmpfile();
	if ( tmpTransFile == NULL )
  {
    fclose(srcBinFile);
		return ERROR;
  }

  //inicializar totales del libro diario
  tSalesDlyBookHeader salesDlyBookHeader;
  memset( &salesDlyBookHeader, 0, sizeof(tSalesDlyBookHeader) );
  
  // Inicializar valores default
  strcpy( salesDlyBookHeader.Proveedor, "EPSON" );
  strcpy( salesDlyBookHeader.Version, DLLVERSION );
  
  //recorrer mientras haya datos en el archivo
  while( !feof( srcBinFile ) )
  {
    //Inicializar linea de transaccion del libro diario
    memset( &salesBookTransaction, 0, sizeof(tSalesBookTransaction) );

    //leer siguiente transaccion
    if ( dwReadNextTransaction(srcBinFile) != SUCCESS)
    {
      fclose(srcBinFile);
      fclose(tmpTransFile);
      return ERROR;
    }

    //Verificar si leyo una transaccion
    if ( AuditTransactionHeaderRecord.DocType == 0 )   
      continue;

    //Obtener datos a grabar en el libro diario
    GetSalesBookTransaction( salesBookTransaction );

    //acumular transaccion en totales diarios
    AcumTransaction( salesDlyBookHeader.totals, salesBookTransaction );

    //grabar transaccion en el archivo
    if ( dwSaveTransactionLine( tmpTransFile, salesBookTransaction ) != SUCCESS)
    {
      fclose(srcBinFile);
      fclose(tmpTransFile);
      return ERROR;
    }
  }

  //Obtener datos encabezado del libro diario
  GetDailyBookHeader( salesDlyBookHeader, pszZNumber );

  //grabar header libro diario
  if ( dwSaveDailyBook( outDlyFile, tmpTransFile, salesDlyBookHeader ) != SUCCESS)
  {
    fclose(srcBinFile);
    fclose(tmpTransFile);
    return ERROR;
  }

  // acumular datos mensuales
  AcumSalesBookTotals( salesBookMonthTotals, salesDlyBookHeader.totals );

  fclose(srcBinFile);
  fclose(tmpTransFile);

	return SUCCESS;
}

bool CTaurusInterfaceApp::UseAuditTransactionHeaderRecordV1( void )
{
  char temp[3];
  temp[2] = '\0';

  memcpy( temp, AuditHeaderRecord.VersionMajor, 2 );
	int VersionMajor = atoi( temp );

  memcpy( temp, AuditHeaderRecord.VersionMinor, 2 );
	int VersionMinor = atoi( temp );

  if ( ( VersionMajor < 2 ) && ( VersionMinor < 4 ) )
  {
    return true;
  }

  return false;
}

DWORD CTaurusInterfaceApp::dwReadNextTransaction(FILE * srcBinFile)
{
  //Inicilizar datos transaccion
  memset( &AuditTransactionHeaderRecord, 0, sizeof(tAuditTransactionHeaderRecordV2) );
  memset( &AuditTransactionExtHeaderRecord, 0, sizeof(tAuditTransactionExtHeaderRecord) );
  memset( &AuditTransactionPaymentRecords, 0, ( sizeof(tAuditTransactionPaymentRecord) * TRANSACTION_PAYMENTS_MAX ) );
  QtyPaymentsUsed = 0;
  memset( &AuditTransactionCloseRecord, 0, sizeof(tAuditTransactionCloseRecord) );

  bool GetNextRecord = true;
  do
  {
    // leer siguiente registro
    switch ( fgetc(srcBinFile) )
    {
      case 0x5a:  // Encabezado archivo
        if ( fread( &AuditHeaderRecord, sizeof(tAuditHeaderRecord), 1,srcBinFile ) != 1 )
          return ERROR;
        break;
      case 0x4A:
        if ( fread( &AuditJournalInfoRecord, sizeof(tAuditJournalInfoRecord), 1,srcBinFile ) != 1 )
          return ERROR;
        break;
      case 0x31:  // Encabezado transaccion
        {
          int RecordSize;
          if ( UseAuditTransactionHeaderRecordV1() )
          {
            RecordSize = sizeof(tAuditTransactionHeaderRecordV1);
          }
          else
          {
            RecordSize = sizeof(tAuditTransactionHeaderRecordV2);
          }
          if ( fread( &AuditTransactionHeaderRecord, RecordSize, 1,srcBinFile ) != 1 )
            return ERROR;
        }
        break;
      case 0x39:  // Encabezado extendido transaccion
        if ( fread( &AuditTransactionExtHeaderRecord, sizeof(tAuditTransactionExtHeaderRecord), 1,srcBinFile ) != 1 )
          return ERROR;
        break;
      case 0x32:  // pago
        if ( QtyPaymentsUsed >= TRANSACTION_PAYMENTS_MAX )
          return ERROR;
        if ( fread( &AuditTransactionPaymentRecords[QtyPaymentsUsed], sizeof(tAuditTransactionPaymentRecord), 1,srcBinFile ) != 1 )
          return ERROR;
        QtyPaymentsUsed++;
        break;
      case 0x42:  // cierre transaccion
        if ( fread( &AuditTransactionCloseRecord, sizeof(tAuditTransactionCloseRecord), 1,srcBinFile ) != 1 )
          return ERROR;
        // no leer mas datos - transaccion finalizada
        GetNextRecord = false;
        break;
      case 0x33:  // Totales transacciones (ultimo registro del archivo)
        // leer registro
        if ( fread( &AuditTransactionTotalsRecord, sizeof(tAuditTransactionTotalsRecord), 1,srcBinFile ) != 1 )
          return ERROR;
        if( fseek( srcBinFile, 0, SEEK_END) )
          return ERROR;
        //NO BREAK!
      case EOF:
      default:
        GetNextRecord = false;
        break;
    }
  }  while ( GetNextRecord );

	return SUCCESS;
}

void CTaurusInterfaceApp::GetSalesBookTransaction( tSalesBookTransaction & salesBookTransaction )
{
  char tempstr[20];

  //Obtener pagos
  //  Se obtienen los montos de todos los registros de pago de la transaccion
  __int64 Payments[TRANSACTION_PAYMENTS_MAX];
  char PayId[3];
  memset( Payments, 0, ( sizeof(__int64)*TRANSACTION_PAYMENTS_MAX ) );
  PayId[2] = '\0';  //add null to id string
  int destndx;
  for (int i = 0; i < QtyPaymentsUsed; i++)
  {
    memcpy(PayId, AuditTransactionPaymentRecords[i].Id, 2 );
    destndx = atoi(PayId) - 1;
    if ( ( destndx >= 0 ) && ( destndx <= ( TRANSACTION_PAYMENTS_MAX - 1 ) ) )
    {
      memcpy( &Payments[destndx], AuditTransactionPaymentRecords[i].Amount, 5 );

      //Monto total - Se obtiene como la suma de todos los montos de todos
      //  los registros de pago de la transaccion.
      salesBookTransaction.Monto += Payments[destndx];
    }
  }

  //Numero RNC
  memcpy(tempstr, AuditHeaderRecord.NumeroRNC, 11);
  tempstr[11] = '\0';
  strcpy(salesBookTransaction.RNCRetailer, TrimLeftSpaces(tempstr) );

  //Sucursal
  memcpy(tempstr, AuditTransactionHeaderRecord.Sucursal, 4);
  tempstr[4] = '\0';
  strcpy(salesBookTransaction.Sucursal, TrimLeftZeros(tempstr) );

  //Caja
  memcpy(tempstr, AuditTransactionHeaderRecord.POSNum, 4);
  tempstr[4] = '\0';
  strcpy(salesBookTransaction.Caja, TrimLeftZeros(tempstr) );

  //NIF
  memcpy(salesBookTransaction.NIF, AuditTransactionHeaderRecord.NIF, 16);

  //Fecha - Convertir formato binario a AAAAMMDD
  word day, month, year;
  CAL_DateToDMY( AuditTransactionHeaderRecord.Date, &day, &month, &year );
  sprintf( salesBookTransaction.Fecha, "%4d%02d%02d", year, month, day );     

  //Hora - Convertir formato binario a HHMMSS
  word hour, min, sec;
  CAL_TimeToHMS( AuditTransactionHeaderRecord.Time, &hour, &min, &sec );
  sprintf( salesBookTransaction.Hora, "%02d%02d%02d", hour, min, sec );     

  //Tipo documento - Convertir ASCII a entero
  salesBookTransaction.TipoDocumento = AuditTransactionHeaderRecord.DocType - '0';

  //Subtipo documento
  if ( Payments[11] > 0 )  //Pago 12 - Exoneracion ITBIS
    salesBookTransaction.SubTipoDocumento += 1; 
  if ( Payments[13] > 0 )  //Pago 14 - Cancelado
    salesBookTransaction.SubTipoDocumento += 2;

  //RNC Cliente
  memcpy(tempstr, AuditTransactionExtHeaderRecord.RNCClient, 11);
  tempstr[11] = '\0';
  strcpy(salesBookTransaction.RNCCliente, TrimLeftSpaces(tempstr) );

  //NCF
  memcpy(tempstr, AuditTransactionExtHeaderRecord.NCF, 19);
  tempstr[19] = '\0';
  //  Si el NCF es todo 0s => dejar string vacio
  if ( strlen( TrimLeftZeros(tempstr) ) > 0 )
    strcpy(salesBookTransaction.NCF, tempstr );

  //NCF Afectado
  memcpy(tempstr, AuditTransactionExtHeaderRecord.NCFAfectado, 19);
  tempstr[19] = '\0';
  //  Si el NCF Afectado es todo 0s => dejar string vacio
  if ( strlen( TrimLeftZeros(tempstr) ) > 0 )
    strcpy(salesBookTransaction.NCFAfectado, tempstr );

  //Monto ITBIS
  memcpy( &salesBookTransaction.ITBIS, AuditTransactionCloseRecord.ITBIS, 5 );
  salesBookTransaction.ITBIS += Payments[11]; //Pago 12 - Exoneracion ITBIS

  //Monto Discount
  unsigned __int64 subtotalDisc = 0;
  unsigned __int64 itemDisc = 0;
  memcpy( &subtotalDisc, AuditTransactionCloseRecord.SubtotalDiscounts, 5 );
  memcpy( &itemDisc, AuditTransactionCloseRecord.ItemDiscounts, 5 );
  salesBookTransaction.MontoDescuento = subtotalDisc + itemDisc;

  //Monto Donacion
  memcpy( &salesBookTransaction.Donacion, AuditTransactionCloseRecord.Donaciones, 5 );

  //Cantidad items
  salesBookTransaction.CantidadItems = ( AuditTransactionCloseRecord.QtyTotalItems - AuditTransactionCloseRecord.QtyExentItems );

  //Cantidad items exento
  salesBookTransaction.CantidadItemsSinITBIS = AuditTransactionCloseRecord.QtyExentItems;

  //Monto EFECTIVO
  //Monto CHEQUE
  //Monto TARJETA CREDITO
  //Monto TARJETA DEBITO
  int j = 0;
  for ( int i = 0; i < 4; i++ )
    salesBookTransaction.Pagos[j++] = Payments[i];

  //Monto Nota de Credito (Pago 11)
  salesBookTransaction.Pagos[j++] = Payments[10];

  //Monto CUPON
  //Monto OTROS 1
  //Monto OTROS 2
  //Monto OTROS 3
  //Monto OTROS 4
  for ( int i = 5; i < 10; i++ )
    salesBookTransaction.Pagos[j++] = Payments[i];
}

void CTaurusInterfaceApp::AcumSalesDlyBookHeader( tSalesDlyBookHeader & totals, tSalesDlyBookHeader & src )
{
  //ID impresora
  strcpy( totals.IDImpresora, src.IDImpresora );

  //acumulado consumidor final
  totals.AcumuladoConsFinal = src.AcumuladoConsFinal;

  //acumulado credito fiscal
  totals.AcumuladoCredFiscal = src.AcumuladoCredFiscal;
  
  //acumulado nota de credito consumidor final
  totals.AcumuladoNotaCredConsFinal = src.AcumuladoNotaCredConsFinal;

  //acumulado nota de credito credito fiscal
  totals.AcumuladoNotaCredCredFisc = src.AcumuladoNotaCredCredFisc;

  //qty docs no venta
  totals.CantidadDocumentosNoVenta += src.CantidadDocumentosNoVenta;

  // Nro Inicial NIF
  if ( strlen( totals.NIFInicial ) == 0 )
    strcpy( totals.NIFInicial, src.NIFInicial );
  
  // Nro final NIF
  strcpy( totals.NIFFinal, src.NIFFinal );

  //Numero de cierre Z
  strcpy( totals.NumeroZ, src.NumeroZ );

  //totales venta, ITBIS, etc
  AcumSalesBookTotals( totals.totals, src.totals );
}

void CTaurusInterfaceApp::GetDailyBookHeader( tSalesDlyBookHeader & dailyBookHeader, char * pszZNumber )
{
  //ID impresora
  memcpy( dailyBookHeader.IDImpresora, AuditHeaderRecord.NumeroInventario, 6 );

  //acumulado consumidor final
  memcpy( &dailyBookHeader.AcumuladoConsFinal, AuditTransactionTotalsRecord.LfTotalTckConsFinal, 7 );

  //acumulado credito fiscal
  memcpy( &dailyBookHeader.AcumuladoCredFiscal, AuditTransactionTotalsRecord.LfTotalTckCrdFisc, 7 );
  
  //acumulado nota de credito consumidor final
  memcpy( &dailyBookHeader.AcumuladoNotaCredConsFinal, AuditTransactionTotalsRecord.LfTotalNCdConsFinal, 7 );

  //acumulado nota de credito credito fiscal
  memcpy( &dailyBookHeader.AcumuladoNotaCredCredFisc, AuditTransactionTotalsRecord.LfTotalNCdCrdFisc, 7 );

  //qty docs no venta
  memcpy( &dailyBookHeader.CantidadDocumentosNoVenta, AuditTransactionTotalsRecord.QtyDNF, 5 );

  // Nro Inicial NIF
  memcpy( dailyBookHeader.NIFInicial, AuditTransactionTotalsRecord.FirstNIF, 16 );
  
  // Nro final NIF
  memcpy( dailyBookHeader.NIFFinal, AuditTransactionTotalsRecord.LastNIF, 16 );

  //Numero de cierre Z
  strcpy( dailyBookHeader.NumeroZ, pszZNumber );

  //Propina legal
  if ( AuditJournalInfoRecord.DiscriminaITBIS == 'S' )
  {
    dailyBookHeader.PropinaLegal[0] = '2'; // Retail (Sin 10% de ley)
  }
  else if ( AuditJournalInfoRecord.DiscriminaITBIS == 'N' )
  {
    if ( AuditJournalInfoRecord.TipRate == 0 )
    {
      dailyBookHeader.PropinaLegal[0] = '1'; // Restaurant sin 10% de propina legal
    }
    else
    {
      dailyBookHeader.PropinaLegal[0] = '0'; // Restaurant con 10% de propina legal
    }
  }
}

void CTaurusInterfaceApp::AcumTransaction( tSalesBookTotals & totals,
                                           tSalesBookTransaction & salesBookTransaction )
{
  totals.CantidadRegistros++;
  totals.MontoTotalArchivo += salesBookTransaction.Monto;
  totals.ITBISTotalArchivo += salesBookTransaction.ITBIS;

  switch ( salesBookTransaction.TipoDocumento )
  {
    case 1:
      totals.MontoConsFinal += salesBookTransaction.Monto;
      totals.ITBISConsFinal += salesBookTransaction.ITBIS;
      break;
    case 2:
      totals.MontoCredFiscal += salesBookTransaction.Monto;
      totals.ITBISCredFiscal += salesBookTransaction.ITBIS;
      break;
    case 3:
      totals.MontoNotaCredConsFinal += salesBookTransaction.Monto;
      totals.ITBISNotaCredConsFinal += salesBookTransaction.ITBIS;
      break;
    case 4:
      totals.MontoNotaCredCredFisc += salesBookTransaction.Monto;
      totals.ITBISNotaCredCredFisc += salesBookTransaction.ITBIS;
      break;
  }
}

char * CTaurusInterfaceApp::TrimLeftZeros(char * str)
{
  while ( *str == '0' )
  {
    str++;
  }

  return str;
}

char * CTaurusInterfaceApp::TrimLeftSpaces(char * str)
{
  while ( *str == ' ' )
  {
    str++;
  }

  return str;
}

void CTaurusInterfaceApp::AddAmount(FILE * outFile, __int64 amount, bool addFldSep)
{
  if ( amount != 0 )
  {
    char tempstr[25];
    char tempstr2[25];

    __int64 intPart = amount / 100;
    __int64 decPart = amount % 100;

    fprintf( outFile, "%s.%02s", _i64toa( intPart, tempstr, 10), _i64toa( decPart, tempstr2, 10) );
  }

  if (addFldSep)
    fputs( "||", outFile );
}

DWORD CTaurusInterfaceApp::dwSaveTransactionLine( FILE	*outFile,
                                                  tSalesBookTransaction & salesBookTransaction )
{
  //ID - Fixed
  fputs( "2||", outFile );

  //RNCRetailer
  fprintf( outFile, "%s||", salesBookTransaction.RNCRetailer );

  //Sucursal
  fprintf( outFile, "%s||", salesBookTransaction.Sucursal );

  //Caja
  fprintf( outFile, "%s||", salesBookTransaction.Caja );

  //NIF
  fprintf( outFile, "%s||", salesBookTransaction.NIF );

  //Fecha
  fprintf( outFile, "%s||", salesBookTransaction.Fecha );

  //Hora
  fprintf( outFile, "%s||", salesBookTransaction.Hora );

  //Tipo documento
  fprintf( outFile, "%d||", salesBookTransaction.TipoDocumento );     

  //Subtipo documento
  if ( salesBookTransaction.SubTipoDocumento > 0 )
    fprintf( outFile, "%d", salesBookTransaction.SubTipoDocumento );
  fputs( "||", outFile ); 

  //RNC Cliente
  fprintf( outFile, "%s||", salesBookTransaction.RNCCliente );

  //NCF
  fprintf( outFile, "%s||", salesBookTransaction.NCF );

  //NCF Afectado
  fprintf( outFile, "%s||", salesBookTransaction.NCFAfectado );

  //Monto total
  AddAmount( outFile, salesBookTransaction.Monto );

  //Monto ITBIS
  AddAmount( outFile, salesBookTransaction.ITBIS );

  //Monto Discount
  AddAmount( outFile, salesBookTransaction.MontoDescuento );

  //Monto Donacion
  AddAmount( outFile, salesBookTransaction.Donacion );

  //Cantidad items
  if ( salesBookTransaction.CantidadItems > 0 )
    fprintf( outFile, "%d", salesBookTransaction.CantidadItems );
  fputs( "||", outFile );       

  //Cantidad items exento
  if ( salesBookTransaction.CantidadItemsSinITBIS > 0 )
    fprintf( outFile, "%d", salesBookTransaction.CantidadItemsSinITBIS );
  fputs( "||", outFile );       

  //Monto EFECTIVO
  //Monto CHEQUE
  //Monto TARJETA CREDITO
  //Monto TARJETA DEBITO
  //Monto Nota de Credito (payment 11)
  //Monto CUPON
  //Monto OTROS 1
  //Monto OTROS 2
  //Monto OTROS 3
  //Monto OTROS 4
  for ( int i = 0; i < 10; i++ )
    AddAmount( outFile, salesBookTransaction.Pagos[i] );

  fputc( '\n', outFile );

  return SUCCESS;
}

DWORD CTaurusInterfaceApp::dwSaveDailyBook( FILE * outDlyFile, FILE	* srcTransFile,
                                            tSalesDlyBookHeader & dailyBookHeader )
{
   char tempstr[25];

   //grabar ID de registro
   fputs( "1||", outDlyFile );

   //calcular hash del archivo srcTransFile => obtener array binario
   BYTE HashBuffer[20];
   DWORD HashBufferLen = 20;
   if ( dwHashFile(srcTransFile, HashBuffer, &HashBufferLen ) != SUCCESS )
   {
      return ERROR;
   }

   //grabar HASH de transacciones
   for ( unsigned int i = 0; i < HashBufferLen; i++ )
      fprintf( outDlyFile, "%02X", HashBuffer[i] );
   fputs( "||", outDlyFile );

   //ID impresora
   fwrite( AuditHeaderRecord.NumeroInventario, 6, 1, outDlyFile );
   fputs( "||", outDlyFile );

   //Numero de registros
   fprintf( outDlyFile, "%d||", dailyBookHeader.totals.CantidadRegistros );

   //Monto total
   AddAmount(outDlyFile, dailyBookHeader.totals.MontoTotalArchivo );

   //Monto ITBIS
   AddAmount(outDlyFile, dailyBookHeader.totals.ITBISTotalArchivo );

   //Monto total (ticket consumidor final)
   AddAmount(outDlyFile, dailyBookHeader.totals.MontoConsFinal );

   //ITBIS
   AddAmount(outDlyFile, dailyBookHeader.totals.ITBISConsFinal );

   //acumulado
   AddAmount(outDlyFile, dailyBookHeader.AcumuladoConsFinal);

   //Monto total (ticket credito fiscal)
   AddAmount(outDlyFile, dailyBookHeader.totals.MontoCredFiscal );

   //ITBIS
   AddAmount(outDlyFile, dailyBookHeader.totals.ITBISCredFiscal );

   //acumulado
   AddAmount(outDlyFile, dailyBookHeader.AcumuladoCredFiscal);

   //Monto total (nota de credito cons final)
   AddAmount(outDlyFile, dailyBookHeader.totals.MontoNotaCredConsFinal );

   //ITBIS
   AddAmount(outDlyFile, dailyBookHeader.totals.ITBISNotaCredConsFinal );

   //acumulado
   AddAmount(outDlyFile, dailyBookHeader.AcumuladoNotaCredConsFinal);

   //Monto total (nota de credito credito fiscal)
   AddAmount(outDlyFile, dailyBookHeader.totals.MontoNotaCredCredFisc );

   //ITBIS
   AddAmount(outDlyFile, dailyBookHeader.totals.ITBISNotaCredCredFisc );

   //Monto acumulado nota de credito credito fiscal
   AddAmount(outDlyFile, dailyBookHeader.AcumuladoNotaCredCredFisc);

   //qty docs no venta
   if ( dailyBookHeader.CantidadDocumentosNoVenta > 0 )
     fprintf( outDlyFile, "%s", _i64toa( dailyBookHeader.CantidadDocumentosNoVenta, tempstr, 10) );
   fputs( "||", outDlyFile ); 

   // Nro Inicial NIF
   fprintf( outDlyFile, "%s||", dailyBookHeader.NIFInicial );

   // Nro final NIF
   fprintf( outDlyFile, "%s||", dailyBookHeader.NIFFinal );

   // Numero de cierre Z
   fprintf( outDlyFile, "%s||", dailyBookHeader.NumeroZ );

   // Proveedor
   fprintf( outDlyFile, "%s||", dailyBookHeader.Proveedor );

   // Version
   fprintf( outDlyFile, "%s||", dailyBookHeader.Version );

   // Propina legal
   fprintf( outDlyFile, "%s||", dailyBookHeader.PropinaLegal );

   fputc( '\n', outDlyFile );

   //copiar archivo de transacciones al libro diario
   FileAppend( outDlyFile, srcTransFile );

   return SUCCESS;
}

DWORD CTaurusInterfaceApp::dwSaveMonthBook( FILE * outMonthFile, FILE * srcDlyBooksFile, 
                                            tSalesBookTotals & totals )
{
   //calcular hash del archivo srcDlyBooksFile => obtener array binario
   BYTE HashBuffer[20];
   DWORD HashBufferLen = 20;
   if ( dwHashFile(srcDlyBooksFile, HashBuffer, &HashBufferLen ) != SUCCESS )
   {
      return ERROR;
   }

   //grabar ID de registro
   fputs( "3||", outMonthFile );

   //grabar HASH de transacciones
   for ( unsigned int i = 0; i < HashBufferLen; i++ )
      fprintf( outMonthFile, "%02X", HashBuffer[i] );
   fputs( "||", outMonthFile );

   //Numero de registros
   fprintf( outMonthFile, "%d||", totals.CantidadRegistros );

   //Monto total
   AddAmount(outMonthFile, totals.MontoTotalArchivo);

   //Monto ITBIS
   AddAmount(outMonthFile, totals.ITBISTotalArchivo);

   //Monto total (ticket consumidor final)
   AddAmount(outMonthFile, totals.MontoConsFinal);

   //ITBIS
   AddAmount(outMonthFile, totals.ITBISConsFinal);

   //Monto total (ticket credito fiscal)
   AddAmount(outMonthFile, totals.MontoCredFiscal);

   // ITBIS
   AddAmount(outMonthFile, totals.ITBISCredFiscal);

   // Monto total (nota de credito cons final)
   AddAmount(outMonthFile, totals.MontoNotaCredConsFinal);

   // ITBIS
   AddAmount(outMonthFile, totals.ITBISNotaCredConsFinal);

   // Monto total (nota de credito credito fiscal)
   AddAmount(outMonthFile, totals.MontoNotaCredCredFisc);

   // ITBIS
   AddAmount(outMonthFile, totals.ITBISNotaCredCredFisc);

   fputc( '\n', outMonthFile );

   //copiar libros diarios al libro mensual
   FileAppend( outMonthFile, srcDlyBooksFile );

   return SUCCESS;
}

DWORD CTaurusInterfaceApp::dwHashFile(FILE * fileToHash, BYTE *pbData, DWORD * pdwDataLen )
{
  HCRYPTPROV hCryptProv;
  HCRYPTHASH hHash;

  //Inicializar provider

  // Get a handle to a cryptography provider context.
  if( !CryptAcquireContext( &hCryptProv, NULL, NULL, PROV_RSA_FULL, CRYPT_VERIFYCONTEXT ) ) 
  {
    return ERROR;
  }

  // Acquire a hash object handle.
  if( !CryptCreateHash( hCryptProv, CALG_SHA1, 0, 0, &hHash) )
  {
    return ERROR;
  }

  //Leer archivo y agregar al hash
  rewind(fileToHash);

  BYTE tempc;
  size_t buflen = 1;
  while( true )
  {
    tempc = fgetc( fileToHash );

    if ( feof( fileToHash ) )
      break;

    if (!CryptHashData( hHash, &tempc, (DWORD) buflen, 0 ) )
    {
      return ERROR;
    }
  }

  //Leer hash
  DWORD temp = ( DWORD ) sizeof(__int32);
  __int32 resultLen;

  if( !CryptGetHashParam( hHash, HP_HASHSIZE, ( BYTE* ) &resultLen, &temp, 0 ) ) 
  {
    return ERROR;
  }

  if( !CryptGetHashParam( hHash, HP_HASHVAL, pbData, pdwDataLen, 0 ) ) 
  {
    return ERROR;
  }

  * pdwDataLen = resultLen;

  // After processing, hCryptProv and hHash must be released.
  if(hHash) 
    CryptDestroyHash(hHash);
  if(hCryptProv) 
    CryptReleaseContext(hCryptProv,0);

  return SUCCESS;
}

void CTaurusInterfaceApp::FileAppend(FILE * fileDest, FILE * fileSrc )
{
  int readLen;
  unsigned char buffer[1024];

  rewind( fileSrc );

  while ( !feof( fileSrc ) )
  {
    readLen = fread( buffer, 1, 1024, fileSrc );

    fwrite( buffer, 1, readLen, fileDest );
  }
}

DWORD CTaurusInterfaceApp::dwGetInfoBtwnDates(char * pszStartDate, char * pszEndDate, int * FirstZNum, int * LastZNum)
{
	STPRINTER_INFORMATION_GET_INFO_BTWN_DATES_IN		stIn;
	STPRINTER_INFORMATION_GET_INFO_BTWN_DATES_OUT	stOut;
	DWORD	dwAnswer;

	if((pszStartDate == NULL) || (pszEndDate == NULL) || (FirstZNum == NULL) || (LastZNum == NULL))
		return ERROR;

	/* Initializing Variables */
	memset( &stIn, 0x00, sizeof( stIn ) );
	memset( &stOut, 0x00, sizeof( stOut ) );

	stIn.szFechaInicial = pszStartDate;
	stIn.szFechaFinal	= pszEndDate;
	stIn.iCommandExtension = 0;

	/* Preparing Interface */
	clsFunctionSelector.dwAddCommandType( FUNCTION_SELECTOR_PRINTER_INFORMATION_GROUP );
	clsFunctionSelector.dwAddCommandDescription( OPTION_GROUP_PRINTER_INFORMATION_GET_INFO_BTWN_DATES );
	clsFunctionSelector.dwAddInputData( &stIn );
	clsFunctionSelector.dwAddOutputData( &stOut );

	dwAnswer = clsFunctionSelector.dwStartProcess();

	if ( ( dwAnswer != SUCCESS ) || (stOut.stFixedAnswer.usResponse != 0x00) )
		return ERROR;

   // get output data
   *FirstZNum = stOut.FirstZNum;
   *LastZNum = stOut.LastZNum;

	return SUCCESS;
}

DWORD CTaurusInterfaceApp::dwStartAuditZ(char * pszStartZ, int iOption)
{
	STPRINTER_INFORMATION_START_AUDIT_Z_IN		stIn;
	STPRINTER_INFORMATION_START_AUDIT_Z_OUT	stOut;
	DWORD				dwAnswer;

	if ( pszStartZ == NULL )
		return ERROR;

	/* Initializing Variables */
	memset( &stIn, 0x00, sizeof( stIn ) );
	memset( &stOut, 0x00, sizeof( stOut ) );


	stIn.szZInicial = pszStartZ;
	stIn.szZFinal	= pszStartZ;
	stIn.iCommandExtension = iOption;

	/* Preparing Interface */
	clsFunctionSelector.dwAddCommandType( FUNCTION_SELECTOR_PRINTER_INFORMATION_GROUP );
	clsFunctionSelector.dwAddCommandDescription( OPTION_GROUP_PRINTER_INFORMATION_START_AUDIT_Z );
	clsFunctionSelector.dwAddInputData( &stIn );
	clsFunctionSelector.dwAddOutputData( &stOut );

	dwAnswer = clsFunctionSelector.dwStartProcess();

	if( (dwAnswer == SUCCESS) && (stOut.stFixedAnswer.usResponse == 0x00))
		return SUCCESS;

	return ERROR;
}


DWORD CTaurusInterfaceApp::dwStartAuditDate(char * pszStartDate, char * pszEndDate, int iOption)
{
	STPRINTER_INFORMATION_START_AUDIT_FECHA_IN		stIn;
	STPRINTER_INFORMATION_START_AUDIT_FECHA_OUT		stOut;
	DWORD				dwAnswer;


	if((pszStartDate == NULL) || (pszEndDate == NULL))
		return ERROR;

	/* Initializing Variables */
	memset( &stIn, 0x00, sizeof( stIn ) );
	memset( &stOut, 0x00, sizeof( stOut ) );


	stIn.szFechaInicial = pszStartDate;
	stIn.szFechaFinal	= pszEndDate;
	stIn.iCommandExtension = iOption;


	/* Preparing Interface */
	clsFunctionSelector.dwAddCommandType( FUNCTION_SELECTOR_PRINTER_INFORMATION_GROUP );
	clsFunctionSelector.dwAddCommandDescription( OPTION_GROUP_PRINTER_INFORMATION_START_AUDIT_FECHA );
	clsFunctionSelector.dwAddInputData( &stIn );
	clsFunctionSelector.dwAddOutputData( &stOut );

	dwAnswer = clsFunctionSelector.dwStartProcess();

	if( (dwAnswer == SUCCESS) && (stOut.stFixedAnswer.usResponse == 0x00))
		return SUCCESS;

	return ERROR;
}


DWORD CTaurusInterfaceApp::dwRunAudit(unsigned char * pszData, int * DataUsed, char * szMoreData, DWORD dwSizeofpszData)
{
	STPRINTER_INFORMATION_PRINTER_RUN_AUDIT_IN		stIn;
	STPRINTER_INFORMATION_PRINTER_RUN_AUDIT_OUT		stOut;
	DWORD				dwAnswer;

	/* Initializing Variables */
	memset( &stIn, 0x00, sizeof( stIn ) );
	memset( &stOut, 0x00, sizeof( stOut ) );

	/* Preparing command */
	stIn.iCommandExtension = EXTENSION_RESERVED;

	/* Preparing Interface */
	clsFunctionSelector.dwAddCommandType( FUNCTION_SELECTOR_PRINTER_INFORMATION_GROUP );
	clsFunctionSelector.dwAddCommandDescription( OPTION_GROUP_PRINTER_INFORMATION_RUN_AUDIT );
	clsFunctionSelector.dwAddInputData( &stIn );
	clsFunctionSelector.dwAddOutputData( &stOut );

	dwAnswer = clsFunctionSelector.dwStartProcess();

	if( (dwAnswer == SUCCESS) && (stOut.stFixedAnswer.usResponse == 0x00))
	{
    memcpy(pszData, stOut.szAuditData, stOut.AuditDataSize);
    *DataUsed = stOut.AuditDataSize;
		*szMoreData = stOut.szMoreData;
		return SUCCESS;
	}

	return ERROR;
}


DWORD CTaurusInterfaceApp::dwEndAudit()
{
	STPRINTER_INFORMATION_PRINTER_END_AUDIT_IN		stIn;
	STPRINTER_INFORMATION_PRINTER_END_AUDIT_OUT		stOut;
	DWORD				dwAnswer;


	/* Initializing Variables */
	memset( &stIn, 0x00, sizeof( stIn ) );
	memset( &stOut, 0x00, sizeof( stOut ) );

	/* Preparing command */
	stIn.iCommandExtension = EXTENSION_RESERVED;

	/* Preparing Interface */
	clsFunctionSelector.dwAddCommandType( FUNCTION_SELECTOR_PRINTER_INFORMATION_GROUP );
	clsFunctionSelector.dwAddCommandDescription( OPTION_GROUP_PRINTER_INFORMATION_END_AUDIT );
	clsFunctionSelector.dwAddInputData( &stIn );
	clsFunctionSelector.dwAddOutputData( &stOut );

	dwAnswer = clsFunctionSelector.dwStartProcess();

	if( (dwAnswer == SUCCESS) && (stOut.stFixedAnswer.usResponse == 0x00))
		return SUCCESS;

	return ERROR;
}



DWORD CTaurusInterfaceApp::dwCancelAudit()
{
	STPRINTER_INFORMATION_PRINTER_CANCEL_AUDIT_IN		stIn;
	STPRINTER_INFORMATION_PRINTER_CANCEL_AUDIT_OUT		stOut;
	DWORD				dwAnswer;


	/* Initializing Variables */
	memset( &stIn, 0x00, sizeof( stIn ) );
	memset( &stOut, 0x00, sizeof( stOut ) );

	/* Preparing command */
	stIn.iCommandExtension = EXTENSION_RESERVED;

	/* Preparing Interface */
	clsFunctionSelector.dwAddCommandType( FUNCTION_SELECTOR_PRINTER_INFORMATION_GROUP );
	clsFunctionSelector.dwAddCommandDescription( OPTION_GROUP_PRINTER_INFORMATION_CANCEL_AUDIT );
	clsFunctionSelector.dwAddInputData( &stIn );
	clsFunctionSelector.dwAddOutputData( &stOut );

	dwAnswer = clsFunctionSelector.dwStartProcess();

	if( (dwAnswer == SUCCESS) && (stOut.stFixedAnswer.usResponse == 0x00))
		return SUCCESS;

	return ERROR;
}

DWORD CTaurusInterfaceApp::dwWriteBinAuditFile()
{
	unsigned char *szBuffer;
	DWORD		dBufferSize=0;
	CHAR		szMoreData;
	DWORD		dwAnswer;
	CHAR		szFileName[1024];
  int     DataUsed;

	iGetEpsonPath(szFileName);
	strcat( szFileName, "temp_audit.tmp" );

	szBuffer = (unsigned char*) malloc(2049);
	if( szBuffer == NULL )
	{
		return ERROR;
	}

	dBufferSize = 2049;
	FILE * dstBinFile = fopen( szFileName, "wb+" );
	if( dstBinFile == NULL )
	{
		free(szBuffer);
		return ERROR;
	}

	szMoreData = 'S';

	while (szMoreData == 'S')
	{
    DataUsed = 0;
		dwAnswer = dwRunAudit(szBuffer, &DataUsed, &szMoreData, dBufferSize);
		if ( dwAnswer != SUCCESS )
    {
	    fclose(dstBinFile);
	    free(szBuffer);
	    return ERROR;
    }

    fwrite( szBuffer, DataUsed, 1, dstBinFile);
	}

	fclose(dstBinFile);
	free(szBuffer);

	return SUCCESS;
}


DWORD CTaurusInterfaceApp::dwVerifyCancelAudit()
{
	STPRINTER_INFORMATION_PRINTER_STATUS_IN		stIn;
	STPRINTER_INFORMATION_PRINTER_STATUS_OUT	stOut;
	DWORD				dwAnswer;

	/* Initializing Variables */
	memset( &stIn, 0x00, sizeof( stIn ) );
	memset( &stOut, 0x00, sizeof( stOut ) );

	/* Preparing command */
	stIn.iCommandExtension = EXTENSION_RESERVED;

	/* Preparing Interface */
	clsFunctionSelector.dwAddCommandType( FUNCTION_SELECTOR_PRINTER_INFORMATION_GROUP );
	clsFunctionSelector.dwAddCommandDescription( OPTION_GROUP_PRINTER_INFORMATION_GET_PRINTER_STATUS );
	clsFunctionSelector.dwAddInputData( &stIn );
	clsFunctionSelector.dwAddOutputData( &stOut );

	dwAnswer = clsFunctionSelector.dwStartProcess();
	if(dwAnswer != SUCCESS)
		return ERROR;

	if(stOut.stFixedAnswer.usFiscalStatus & 0x0040)
		dwAnswer = dwCancelAudit();

	return dwAnswer;
}