#ifndef _UTILS_H_
#define _UTILS_H_

#include <time.h>

#define STRING_NUMERIC_BUFF				51		

#define ANSWER_FIXED_FIELDS_COUNTER		0x05
#define ANSWER_FIRST_OPTIONAL_FIELD		0x06

#define ANSWER_FIELD_SEQUENCE_NUMBER	0x00
#define ANSWER_FIELD_PRINTER_STATUS		0x01
#define ANSWER_FIELD_FISCAL_STATUS		0x02
#define ANSWER_FIELD_RESERVED_1			0x03
#define	ANSWER_FIELD_COMMAND_RESPONSE	0x04
#define ANSWER_FIELD_RESERVED_2			0x05
#define	ANSWER_FIELD_1					0x06
#define ANSWER_FIELD_2					0x07
#define ANSWER_FIELD_3					0x08
#define ANSWER_FIELD_4					0x09
#define ANSWER_FIELD_5					0x0A
#define ANSWER_FIELD_6					0x0B
#define ANSWER_FIELD_7					0x0C
#define ANSWER_FIELD_8					0x0D
#define ANSWER_FIELD_9					0x0E
#define ANSWER_FIELD_10					0x0F
#define ANSWER_FIELD_11					0x10
#define ANSWER_FIELD_12					0x11
#define ANSWER_FIELD_13					0x12
#define ANSWER_FIELD_14					0x13
#define ANSWER_FIELD_15					0x14
#define ANSWER_FIELD_16					0x15
#define ANSWER_FIELD_MAX				0x15

#define ANSWER_TYPE_UNSIGNED_CHAR		0x00
#define ANSWER_TYPE_CHAR				0x01
#define ANSWER_TYPE_UNSIGNED_SHORT		0x02
#define ANSWER_TYPE_SHORT				0x03
#define ANSWER_TYPE_UNSIGNED_INT		0x04
#define ANSWER_TYPE_INT					0x05
#define ANSWER_TYPE_UNSIGNED_LONG		0x06
#define ANSWER_TYPE_LONG				0x07
#define ANSWER_TYPE_STRING				0x08
#define ANSWER_TYPE_BINARY				0x09

#define STX_CHAR						0x02
#define ETX_CHAR						0x03
#define ACK_CHAR						0x06
#define NCK_CHAR						0x15
#define ESC_CHAR						0x1B
#define SEP_CHAR						0x1C
#define INT_CHAR						0x80

#define MAX_BUFFER_LENGTH				0x2000	
#define MAX_SEND_LENGTH					0x0800

#define MIN_SEQUENCE_NUMBER				0x81
#define MAX_SEQUENCE_NUMBER				0xFF

#define ADDING_OPERATION_COMPLETE		0x0000
#define ERROR_ADDING_INVALID_FIELD		0x0001

#define MESSAGE_TYPE_BINARY				0x01
#define MESSAGE_TYPE_ASCII				0x02


#define MAKESHORT(A,B)	(short)          ( (( (short) A << 8 ) & 0xFF00) + ( (short) B & 0x00FF) )
#define MAKEUSHORT(A,B) (unsigned short) ( (( (short) A << 8 ) & 0xFF00) + ( (short) B & 0x00FF) )
#define MAKEUCHAR(A,B)  (unsigned char)  ( (( (char) A << 4 ) & 0XF0) + ( (char) B & 0x0F) )

#ifndef SUCCESS
#define SUCCESS 0
#else
#undef SUCCESS
#define SUCCESS 0
#endif /* SUCCESS */

#ifndef ERROR
#define ERROR 1
#else
#undef ERROR
#define ERROR 1
#endif /* ERROR */

#ifndef LL_ERROR
#define LL_ERROR 2
#else
#undef LL_ERROR
#define LL_ERROR 2
#endif /* LL_ERROR */

// Functions
#define atoi64(str) _atoi64(str)

// Sprintf Types
#define LONG64 "I64d"

#define REPORT_X_SERIAL_SPACES	60

typedef struct {
	unsigned char * pszValor;
	char * pszTexto;
} STPRINT_STRUCTURE;

typedef struct
{
	unsigned char szSalesMessages[8][64];
} STSALES_MESSAGES, * PSTSALES_MESSAGES;

void vSleep( clock_t  );
unsigned char uchGetSequenceNumber( void );
void vSetSequenceNumber( void );
bool bIs_Escaped_Char( unsigned char );
bool bIs_Hexadecimal( unsigned char );
unsigned short sHexadecimal_Value( unsigned char, unsigned char );
int iField_Numeric_Value( unsigned char *,  int, int * );
int iFloatToString( unsigned char * );
bool bStringToFloat( unsigned char *, unsigned char );
void vReplaceChar( unsigned char *, unsigned char , unsigned char );

bool bStringToDateHour( unsigned char *, unsigned char *, unsigned char * );

void vTrimZeroL ( CHAR * szTemp);

void vCheckLogFlag(DWORD * dwLogAction);
DWORD dwEpsonLogPath( LPSTR pszPath );

// MateusPL begin may 18 2005
// Convert text file ro Rich Text
// Returns	0 - ok
//			1 - input file error - not found, cannot open, etc
//			2 - output file error - cannot create
// Attention: This function overwrites the output file.
int iConvertTxtToRtf( char *szTxtFile, char *szRtfFile );
// MateusPL end

// MateusPL jul 12 2005
// Prepare data to print barcode
int iBuildBarCodeSequence( INT, INT, INT, INT, INT, LPSTR, LPSTR );
// MateusPL end

// Check field types
// One bit of DWORD for each check type
#define EPSON_FIELD_STRING								0x0001
// #define EPSON_FIELD_OPTIONAL_STRING_POINTER			0x0002
// Begin - Mateus 05/01/2005
#define EPSON_FIELD_DATE								0x0002
#define EPSON_FIELD_TIME								0x0004
#define EPSON_FIELD_OPT_DATE							0x0008
#define EPSON_FIELD_OPT_TIME							0x0010
#define EPSON_FIELD_STR_NOEMPTY							0x0020

// Check field error codes
#define EPSON_FIELD_STRING_ERR							0x01
#define EPSON_FIELD_DATE_ERR							0x02
#define EPSON_FIELD_TIME_ERR							0x03
#define EPSON_FIELD_OPT_DATE_ERR						0x04
#define EPSON_FIELD_OPT_TIME_ERR						0x05
#define EPSON_FIELD_STR_NOEMPTY_ERR						0x06
#define EPSON_FIELD_BUFFER_ERR							0x07
// End - MateusPL

bool if_true( char chFlag );
bool if_false( char chFlag );

int iCheckTimeField( unsigned char *, int * );
int iCheckDateField( unsigned char *, int * );
int iConvertDate( unsigned char *, int );
int iConvertTime( unsigned char *, int );

INT iGetEpsonPath(CHAR * szAppPath);
INT iCreatePath(CHAR * szPath);

int iAnoBissexto( unsigned int ); 
int iMonthDays( unsigned char *, unsigned char * );
int iCheckCPFCNPJ( unsigned char * );
int iConvertCPFCNPJ( unsigned char * );
void vCodeGrandTotal( unsigned char * , unsigned char * );

unsigned char * pszSkipLeadingZeros( unsigned char * );
int iGetDecimalPlaces( unsigned char * , unsigned char , int * );

void vConvertBemaToEpsonMedia( unsigned char *, int );

#define INTERNAL_DATE_FORMAT_DDMMAA			0x01
#define INTERNAL_DATE_FORMAT_DDMMAAAA		0x02
#define INTERNAL_DATE_FORMAT_DD_MM_AA		0x03
#define INTERNAL_DATE_FORMAT_DD_MM_AAAA		0x04

#define INTERNAL_TIME_FORMAT_HHMMSS			0x01
#define INTERNAL_TIME_FORMAT_HH_MM_SS		0x02
#define INTERNAL_CHECK_SUCCESS				0x00
#define INTERNAL_CHECK_ERROR				0x01

#define PRINTER_INFORMATION_CREDIT			0x00
#define PRINTER_INFORMATION_DEBIT			0x01
#define PRINTER_INFORMATION_ADD_MEDIA		0x02
#define PRINTER_INFORMATION_SUB_MEDIA		0x03

typedef struct {
	unsigned char * pszItemPointer;
	int				iItemPosition;
} STGET_FIELDS_STRUCTURE;

// MateusPL jul 12 2005
typedef struct {
	INT iPrintBarcode; // (==0) - do not print; (!=0) - yes, print it
	INT iType;
	INT iHeight;
	INT iWidth;
	INT iPosition;
	INT iCharType;
} STBARCODE_PROPERTIES;
// MateusPL end

/*-----------------------------------------------------------------------------
   Data Types
-----------------------------------------------------------------------------*/
typedef unsigned __int16 word;
typedef word tJulianDate;
typedef tJulianDate tDate;

typedef unsigned __int32 dword;
typedef dword tSecondsFromMidnight;
typedef tSecondsFromMidnight tTime;

void CAL_DateToDMY( tDate date, word *day, word *month, word *year );
void CAL_TimeToHMS( tTime time, word *hour, word *min, word *sec );

#endif /* _UTILS_H_ */
