#ifndef _SERIAL_H_
#define _SERIAL_H_

/***********************************************************************/
/* SERIAL.H :                                                          */
/*      Contains Prototypes and Defines used to send and receive data  */
/*  throught the serial port                                           */
/***********************************************************************/
/* Revision History:                                                   */
/*                                                                     */
/* Date        Nummber    Revision Name     Author Name                */
/* 23/05/2003    1.0      Initial Version   Marcus Vinicius Scolastici */
/***********************************************************************/
//#include "stdafx.h"
//#include "utils.h"

#ifdef COMPILE_LOG_SERIAL
#include "LogUtils.h"
#endif

/* Error Codes Definitions */
#define SERIAL_NO_ERROR								      0x00
#define ERROR_SERIAL_INTERNAL_ERROR					0x0F

#define SERIAL_WRITE_TIMEOUT						    0x05

#define SERIAL_PORT_OPEN_OK							    0x00
#define ERROR_SERIAL_ALREADY_OPEN					  0x01
#define ERROR_SERIAL_IN_USE							    0x02
#define ERROR_SERIAL_PORT_NOT_OPEN					0x03
#define ERROR_SERIAL_INVALID_COM					  0x04
#define ERROR_SERIAL_INVALID_BAUD_RATE			0x05
#define ERROR_SERIAL_TIMEOUT_ERROR					0x06
#define ERROR_SERIAL_SEND_ERROR						  0x07
#define ERROR_SERIAL_OFF_OR_DISCONNECTED		0x08
#define ERROR_SERIAL_BUFFER_OVERFLOW				0x09
#define ERROR_SERIAL_INVALID_FIELD					0x0A
#define ERROR_SERIAL_INVALID_ANSWER_FIELD		0x0B
#define ERROR_SERIAL_ANSWER_FIELD_NOT_FOUND	0x0C
#define ERROR_SERIAL_INVALID_FIELD_TYPE			0x0D
#define ERROR_SERIAL_PARAMETER_NULL					0x0E
#define ERROR_SERIAL_INVALID_HANDLE					0x0F
#define ERROR_SERIAL_INVALID_BUFFER_SIZE		0x10
#define ERROR_SERIAL_INVALID_PARITY					0x11
#define ERROR_SERIAL_INVALID_DATA_BITS			0x12
#define ERROR_SERIAL_INVALID_STOP_BITS			0x13
#define ERROR_SERIAL_INVALID_COMM_STATE			0x14
#define ERROR_SERIAL_INVALID_TIMEOUT				0x15
#define ERROR_SERIAL_OVERLAPPED_EVENT				0x16
#define ERROR_SERIAL_RECEIVE_ERROR					0x17
#define ERROR_SERIAL_NACK_ERROR						  0x18
#define	ERROR_SERIAL_SET_COM_MASK					  0x19
#define ERROR_SERIAL_GET_MODEM_STATUS				0x1A

#define SERIAL_STATE_CLOSED							    0x00
#define SERIAL_STATE_OPEN							      0x01
#define SERIAL_STATE_BUSY							      0x02

/* Serial Baud Rates Timeouts */
#define SERIAL_1200_BPS_TIMEOUT						  0x19
#define SERIAL_2400_BPS_TIMEOUT						  0x14
#define SERIAL_4800_BPS_TIMEOUT						  0x0E
#define SERIAL_9600_BPS_TIMEOUT						  0x0A
#define SERIAL_19200_BPS_TIMEOUT					  0x0A
#define SERIAL_38400_BPS_TIMEOUT					  0x0A

#define SERIAL_MIN_CHAR_TIMEOUT						  0x0A

#define READ_TIMEOUT								        2500UL
#define FULL_TIMEOUT								        1500UL
#define WRITE_OFF_TIMEOUT							      1500UL

#define SERIAL_MESSAGE_TYPE_1						    0x01
#define SERIAL_MESSAGE_TYPE_2						    0x02

typedef struct
{
	short sComm_Port;
	int   iBaud_Rate;
	short sParity;
	short sData_Bits;
	short sStop_Bits;
} STSERIAL_CONFIG, * PSTSERIAL_CONFIG;

class CSerial 
{
	private:
		COMSTAT			comStat;
		HANDLE			hlCom;								/* Handle to the COM Port						*/
		unsigned char	szSendMessage[MAX_BUFFER_LENGTH];	/* Buffer to Send Data							*/
		int				iSendLength;						/* Send Buffer Size								*/
		unsigned char	szRecvMessage[MAX_BUFFER_LENGTH];	/* Buffer to receive data						*/
		int				iRecvLength;						/* Receive Buffer Size							*/
		unsigned char   szAuxMessage[MAX_BUFFER_LENGTH];    /* Auxiliary Buffer	*/
		int				iAuxLength;							/* Auxiliary Buffer Length */
		unsigned char   szAuxReturn[MAX_BUFFER_LENGTH];
		int             iAuxReturnLength;
		int				iMaxDataAllowed;
		int				iMaxDataAllowedAux;

		BOOL			bPortReady;							/* Port Ready - False: No, True: Yes			*/
		DCB				dcb;		                        /* Data Communications Block					*/		
		COMMTIMEOUTS	CommTimeouts;
		int				iCommState;	
		int				iTotalTimeout;						/* Internal Value to Handle the total timeout.	*/
		int				iMessageType;
		int				iMsgAuxType;
		int				iLastCommError;

		BYTE			szInternalBuffer[4096];
		int				iBufferPosition;

		int		iCSerial_Setup_Comm_Port( short , string *  );
		int		iCSerial_Create_Handle( string );
		int		iCSerial_Setup_Buffer( void );
		int		iCSerial_Setup_Parity( short );
		int		iCSerial_Setup_Data_Bits( short );
		int		iCSerial_Setup_Stop_Bits( short );
		int		iCSerial_Setup_Baud_Rate( int );
		int		iCSerial_Set_Comm_State( void );
		int		iCSerial_Set_Comm_TimeOut( void );
		int		iCSerial_Calculate_CheckSum( void );
		int  	iCSerial_Prepare_Message( void );
		int		iCSerial_Send_Buffer( void );
		int		iCSerial_Receive_Buffer( unsigned char * );
		int   iCSerial_Receive_Buffer( unsigned char *, int * );

		int		iCSerial_Parse_Answer( void );

	public:		
		CSerial();
		~CSerial();

		void	vCSerial_Close_Handle( void );
		void    vCSerial_Recover_Message( void );
		void	vCSerial_Purge_Message(void);
		int		iCSerial_Setup_Comm_Port( PSTSERIAL_CONFIG  );
		int		iCSerial_Get_Comm_State( void );		
		int		iCSerial_Send_Message( void );
		int		iCSerial_Add_FieldEx( unsigned char *, size_t, unsigned int, bool );
		int		iCSerial_Add_Field( unsigned char *, size_t );
		int		iCSerial_Get_FieldEx( void *, int *, int , int );
		int		iCSerial_Get_Field( void *, int *, int );
		int		iCSerial_Get_Comm_Status( void );
		int		iCSerial_Get_Field_Counter(void);
		void    vCSerial_Set_Comm_State( int );
		int     iCSerial_Get_Sent_Frame( unsigned char *, int * );
		int     iCSerial_Get_Received_Frame( unsigned char *, int * );
		int     iCSerial_Get_Last_Comm_Error( void );
		void    vCSerial_Set_Last_Comm_Error( int );

		/* New serial functions */
		int		iCSerial_Open_Serial_Port( PSTSERIAL_CONFIG );
		int		iCSerial_Close_Serial_Port( void );
		int		iCSerial_Send_Buffer( unsigned char *, int );
		void	vCSerial_Receive_Buffer( unsigned char *, int * );
		bool    bCSerial_Is_Data_Available( void );

		#ifdef COMPILE_LOG_SERIAL
		Logger			clsLog;
		public:
		char			chAction;
		#endif
};

/* Functions that call the public functions of the class */
int   _iSerial_Open_Port( PSTSERIAL_CONFIG  );
int   _iSerial_Close_Port( void );
int  _iSerial_Send_Message( void );
int   _iSerial_Resend_Message( void );
int   _iSerial_Add_Field( unsigned char *, size_t );
int   _iSerial_Add_FieldEx( unsigned char * , size_t , unsigned int, bool );
int   _iSerial_Get_Field( void *, int *, int );
int	  _iSerial_Get_FieldEx( void *, int *, int, int );
int   _iSerial_Get_Field_Counter( void );
void  _vSerial_Purge_Message( void );
int _iSerial_Get_Comm_State( void );
int _iSerial_Get_Last_Comm_Error( void );
int _iSerial_Get_Sent_Frame( unsigned char *, int * );
int _iSerial_Get_Received_Frame( unsigned char * , int * );
int _iSerial_Send_Buffer( unsigned char * szBuffer, int iBufferSize );
int _iSerial_Get_Comm_Status( void );

#ifdef COMPILE_LOG_SERIAL
void _vSerial_Set_Log( char * szUserParh, char chUserAction );
#endif


UINT __cdecl _iSerial_Launch_Send_Thread( LPVOID );

#endif /* _SERIAL_H_ */