#ifndef _EPSON_FISCAL_PROTOCOL_H_
#define _EPSON_FISCAL_PROTOCOL_H_

#pragma once

#define EFPROT_SUCCESS								  0x00
#define EFPROT_PORT_ALREADY_OPEN				0x01
#define EFPROT_PORT_IN_USE							0x02
#define EFPROT_PORT_NOT_OPEN						0x03
#define EFPROT_INVALID_COM							0x04
#define EFPROT_INVALID_BAUD_RATE				0x05
#define EFPROT_TIMEOUT_ERROR						0x06
#define EFPROT_SEND_ERROR							  0x07
#define EFPROT_OFF_OR_DISCONNECTED			0x08
#define EFPROT_BUFFER_OVERFLOW					0x09
#define EFPROT_FIELD_INVALID						0x0A
#define EFPROT_ASWR_INVALID							0x0B
#define EFPROT_ASWR_FIELD_INEXISTENT		0x0C
#define EFPROT_FIELD_INVALID_TYPE				0x0D
#define EFPROT_INVALID_PARAM						0x0E
#define EFPROT_INTERNAL_ERROR						0x0F

/* Funes Grupo Outras */
DWORD   OpenSerialPort( WORD, DWORD );
DWORD   CloseSerialPort( void );
DWORD   SendSerialMessage( void );
DWORD	  ResendSerialMessage( void );
DWORD   AddMessageField( BYTE *, DWORD );
DWORD   AddMessageFieldEx( BYTE *, DWORD, DWORD, bool );
void    PurgeMessage( void );
DWORD   GetFieldCounter( void );
DWORD   GetMessageField( BYTE *, DWORD , DWORD );
DWORD   GetMessageFieldEx( void *, DWORD *, DWORD, DWORD );
DWORD   GetCommunicationState( void );
DWORD   GetLastCommError( void );
DWORD   GetSentFrame( BYTE *, DWORD *);
DWORD   GetReceivedFrame( BYTE *, DWORD * );

#endif /* _EPSON_FISCAL_PROTOCOL_H_ */

