#include "selector.h"
#include "structsIn.h"
#include "LogUtils.h"

#pragma pack(push, 1)
typedef struct
{
  char NumeroInventario[6];
  char NumeroSerie[10];
  char NumeroRNC[11];
  unsigned __int16 Date;
  unsigned __int32 Time;
  unsigned __int16 StartDate;
  unsigned __int16 EndDate;
  unsigned __int16 ZStart;
  unsigned __int16 ZEnd;
  char VersionMajor[2];
  char VersionMinor[2];
} tAuditHeaderRecord;

typedef struct
{
  char DiscriminaITBIS;
  unsigned __int16 TipRate;
} tAuditJournalInfoRecord;

typedef struct
{
  unsigned __int16 Date;
  unsigned __int32 Time;
  char NIF[16];
  char Sucursal[4];
  char POSNum[4];
  unsigned char DocType;
} tAuditTransactionHeaderRecordV1;

typedef struct
{
  unsigned __int16 Date;
  unsigned __int32 Time;
  char NIF[16];
  char Sucursal[4];
  char POSNum[4];
  unsigned char DocType;
  char UseTipRate[1];
} tAuditTransactionHeaderRecordV2;

typedef struct
{
  char RNCClient[11];
  char FiscalNameClient[40];
  char NCF[19];
  char NCFAfectado[19];
} tAuditTransactionExtHeaderRecord;

typedef struct
{
  char Id[2];
  char Description[30];
  unsigned char Amount[5];
} tAuditTransactionPaymentRecord;

typedef struct
{
  unsigned char ITBIS[5];
  unsigned char SubtotalDiscounts[5];
  unsigned char SubtotalRecharges[5];
  unsigned char ItemDiscounts[5];
  unsigned char ItemRecharges[5];
  unsigned char Donaciones[5];
  unsigned __int16 QtyTotalItems;
  unsigned __int16 QtyExentItems;
  unsigned char Cancel;
} tAuditTransactionCloseRecord;

typedef struct
{
  unsigned char Total[7];
  unsigned char ITBIS[7];
  unsigned char SubtotalDiscounts[7];
  unsigned char SubtotalRecharges[7];
  unsigned char ItemDiscounts[7];
  unsigned char ItemRecharges[7];
  unsigned char Donaciones[7];
  unsigned char QtyTckConsFinal[5];
  unsigned char QtyTckCrdFisc[5];
  unsigned char QtyNCdConsFinal[5];
  unsigned char QtyNCdCrdFisc[5];
  unsigned char QtyDNF[5];
  unsigned char QtyCancel[5];
  unsigned char TotalTckConsFinal[7];
  unsigned char TotalTckCrdFisc[7];
  unsigned char TotalNCdConsFinal[7];
  unsigned char TotalNCdCrdFisc[7];
  unsigned char ITBISTckConsFinal[7];
  unsigned char ITBISTckCrdFisc[7];
  unsigned char ITBISNCdConsFinal[7];
  unsigned char ITBISNCdCrdFisc[7];
  unsigned char LfTotalTckConsFinal[7];
  unsigned char LfTotalTckCrdFisc[7];
  unsigned char LfTotalNCdConsFinal[7];
  unsigned char LfTotalNCdCrdFisc[7];
  unsigned char LfITBISTckConsFinal[7];
  unsigned char LfITBISTckCrdFisc[7];
  unsigned char LfITBISNCdConsFinal[7];
  unsigned char LfITBISNCdCrdFisc[7];
  char FirstNIF[16];
  char LastNIF[16];
} tAuditTransactionTotalsRecord;

#pragma pack(pop)

typedef struct
{
  char    RNCRetailer[15];
  char    Sucursal[5];
  char    Caja[5];
  char    NIF[17];
  char    Fecha[9];
  char    Hora[7];
  int     TipoDocumento;
  int     SubTipoDocumento;
  char    RNCCliente[15];
  char    NCF[20];
  char    NCFAfectado[20];
  __int64 Monto;
  __int64 ITBIS;
  __int64 MontoDescuento;
  __int64 Donacion;
  int     CantidadItems;
  int     CantidadItemsSinITBIS;
  __int64 Pagos[10];
} tSalesBookTransaction;

typedef struct
{
  int     CantidadRegistros;
  __int64 MontoTotalArchivo;
  __int64 ITBISTotalArchivo;
  __int64 MontoConsFinal;
  __int64 ITBISConsFinal;
  __int64 MontoCredFiscal;
  __int64 ITBISCredFiscal;
  __int64 MontoNotaCredConsFinal;
  __int64 ITBISNotaCredConsFinal;
  __int64 MontoNotaCredCredFisc;
  __int64 ITBISNotaCredCredFisc;
} tSalesBookTotals;

typedef struct
{
  char IDImpresora[7];
  tSalesBookTotals totals;
  __int64 AcumuladoConsFinal;
  __int64 AcumuladoCredFiscal;
  __int64 AcumuladoNotaCredConsFinal;
  __int64 AcumuladoNotaCredCredFisc;
  __int64 CantidadDocumentosNoVenta;
  char    NIFInicial[17];
  char    NIFFinal[17];
  char    NumeroZ[6];
  char    Proveedor[51];
  char    Version[11];
  char    PropinaLegal[2];
} tSalesDlyBookHeader;

// This class is exported from the TaurusInterface.dll
class CTaurusInterfaceApp {
public:
	CTaurusInterfaceApp(void);

  DWORD dwVerificarConexion (char * pszPort);
  DWORD dwLeerLibroZ(char * pszZNumber, char * pszNombreArchivoSalida);
  DWORD dwLeerLibroDiario(char * pszFecha, char * pszNombreArchivoSalida);
  DWORD dwLeerLibroMensual(char * pszFechaDesde, char * pszFechaHasta, char * pszNombreArchivoSalida);
  DWORD dwGenerarLibroMensual(char * pszDirectorio, char * pszNombreArchivoSalida);

private:

  // Interface functions
  DWORD dwLeerZ( FILE * pDestDlyFile, char * pszZNumber );

  // Communication functions
  Logger clsLog;
  CFunctionSelector clsFunctionSelector;
  DWORD  dwCommunicationAnswer;
  DWORD  dwFiscalStatus;
  DWORD  dwPrinterStatus;
  DWORD  dwCommandResponse;

	DWORD dwOpenSerialPort( DWORD, WORD, WORD, WORD, WORD );
	DWORD dwCloseSerialPort( VOID );
  VOID  vSetInternalState( DWORD dwPrinter, DWORD dwFiscal, DWORD dwCommand );

  // Commands functions
  DWORD dwGetInfoBtwnDates(char * pszStartDate, char * pszEndDate, int * FirstZNum, int * LastZNum);
  DWORD dwStartAuditZ(char * szStartZ, int iOption);
  DWORD dwStartAuditDate(char * szStartDate, char * szEndDate, int iOption);
  DWORD dwRunAudit(unsigned char * pszData, int * DataUsed, char * szMoreData, DWORD dwSizeofpszData);
  DWORD dwEndAudit();
  DWORD dwCancelAudit();
  DWORD dwVerifyCancelAudit();

  // Binary audit file functions
  DWORD dwWriteBinAuditFile();
  DWORD dwParseBinAuditFile( FILE * outDlyFile, char * pszZNumber );
  bool UseAuditTransactionHeaderRecordV1( void );
  DWORD dwReadNextTransaction( FILE * srcBinFile );
  void GetSalesBookTransaction( tSalesBookTransaction & salesBookTransaction );
  void GetDailyBookHeader( tSalesDlyBookHeader & dailyBookHeader, char * pszZNumber );
  void AcumTransaction( tSalesBookTotals & totals, tSalesBookTransaction & salesBookTransaction );

  // Sales book functions
  void AddAmount(FILE * outFile, __int64 amount, bool addFldSep = true);
  void AcumSalesBookTotals( tSalesBookTotals & totals, tSalesBookTotals & src );
  void AcumSalesDlyBookHeader( tSalesDlyBookHeader & totals, tSalesDlyBookHeader & src );
  DWORD dwSaveTransactionLine( FILE	*outFile, tSalesBookTransaction & salesBookTransaction );
  DWORD dwSaveDailyBook( FILE * outDlyFile, FILE * srcTransFile, tSalesDlyBookHeader & dailyBookHeader );
  DWORD dwSaveMonthBook( FILE * outMonthFile, FILE * srcDlyBooksFile, tSalesBookTotals & totals );
  DWORD dwHashFile(FILE * fileToHash, BYTE *pbData, DWORD * pdwDataLen );
  DWORD dwReadDailyBook( FILE * outDlyBooksFile, char * pszFile );
  bool ReadDailyBookLine( FILE	*srcFile );
  bool ReadTransactionLine( FILE	*srcFile );
  bool GetNextField(FILE	*srcFile, char * buffer, int bufsize);

  // Tool functions
  char * TrimLeftZeros(char * str);
  char * TrimLeftSpaces(char * str);
  void FileAppend(FILE * fileDest, FILE * fileSrc);

  // Communicatios vars
  int iComPort,iComSpeed;

  // Totales mensuales
  tSalesBookTotals salesBookMonthTotals;

  // Datos encabezado auditoria
  tAuditHeaderRecord        AuditHeaderRecord;
  tAuditJournalInfoRecord   AuditJournalInfoRecord;

  static const int TRANSACTION_PAYMENTS_MAX = 14;
  // Datos transacciones
  tAuditTransactionHeaderRecordV2  AuditTransactionHeaderRecord;
  tAuditTransactionExtHeaderRecord AuditTransactionExtHeaderRecord;
  tAuditTransactionPaymentRecord   AuditTransactionPaymentRecords[TRANSACTION_PAYMENTS_MAX];
  int QtyPaymentsUsed;
  tAuditTransactionCloseRecord     AuditTransactionCloseRecord;
  tAuditTransactionTotalsRecord    AuditTransactionTotalsRecord;
};
