'=============================================================================
' EFPQB.BAS                                                  EPSON Argentina
'=============================================================================
' EPSON Fiscal Printer Device driver example.
'=============================================================================
' Date             Author                  Comment
' 15-04-2004       Ricardo Malerba         Initial Version
'=============================================================================

'=============================================================================
' Proposito: Muestra uso del driver DOS bajo un programa en Quick Basic
' Operacion: Ticket de monto 1 + Cierre Z
' Compilador: Quick Basic 4.5
' Linea de comando:
' Requisitos: Impresora fiscal serializada
'=============================================================================

' Max cantidad de datos a transmitir
CONST EFPMAXFIELDLEN =   2048

' Comandos del driver
CONST CMDWRITEADDFIELD   = "0"
CONST CMDWRITESEND       = "1"
CONST CMDWRITEPURGE      = "2"
CONST CMDREADANSWER      = "3"
CONST CMDREADEXTRAFIELDS = "4"
CONST CMDREADLOGS        = "5"

' Retornos
CONST EFPSuccess             =  0
CONST EFPEOutBufferFull      = -1
CONST EFPEInvalidDataInField = -2
CONST EFPEWriteFail          = -3
CONST EFPEReadTimeOut        = -4
CONST EFPENackReceived       = -5
CONST EFPEInvalidIndex       = -6
CONST EFPEBufferTooSmall     = -7
CONST EFPEInvalidCommand     = -8

' Registro comn a todos los comandos
TYPE tHeader
  Cmd AS STRING * 1      'Tamanio 1 byte'
  LastError AS INTEGER   'Tamanio 2 bytes'
END TYPE

'Registro para el comando "AddDataField"'
TYPE tAddDataField
  Header AS tHeader
  Length AS INTEGER
  Buffer AS STRING * EFPMAXFIELDLEN 'Maximo largo de datos que se puede enviar'
END TYPE
  
'Registro para el comando "SendCommand"
TYPE tSendFrame
  Header AS tHeader
END TYPE

'Registro para el comando "GetFinalAnswer"'
TYPE tFinalAnswer
  Header AS tHeader
  FiscalStatus AS INTEGER
  PrinterStatus AS INTEGER
  ReturnCode AS INTEGER
  ExtraFieldsCount AS INTEGER
END TYPE

'Registro para el comando "GetExtraField"'
TYPE tExtraField
  Header AS tHeader
  IndexLength AS INTEGER
  Buffer AS STRING * EFPMAXFIELDLEN
END TYPE

'Registro para el comando "GetLog"
TYPE tLogBuffer
  Header AS tHeader
  LogLen AS INTEGER
  LogBuffer AS STRING * 8192
END TYPE

DECLARE SUB main ()
DECLARE SUB HandleError (Message AS STRING, ErrorNum AS INTEGER)
DECLARE SUB AddField (Buffer AS STRING, Length AS INTEGER)
DECLARE SUB SendFrame ()
DECLARE SUB GetFinalAnswer (FiscalStatus AS INTEGER, PrinterStatus AS INTEGER, ReturnCode AS INTEGER, ExtraFieldsCount AS INTEGER)
DECLARE SUB GetExtraField (Buffer AS STRING, IndexLen AS INTEGER)
DECLARE SUB GetLog (Buffer AS STRING, BufferLen AS INTEGER)
DECLARE SUB TicketAndClosure ()

CLEAR , , 16000

'Variables globales
DIM SHARED LogBuf AS STRING * 8192
DIM SHARED FileBuf AS STRING

'Rutina principal
CALL main

'-----------------------------------------------------------------------------
' Function Name : AddField
' Description   : Suma datos a la trama de envio.
' Input         : Buffer y largo
' Outupt        : Nada
' Notes         :
'-----------------------------------------------------------------------------
SUB AddField (Buffer AS STRING, Length AS INTEGER)
DIM MyRecord AS tAddDataField

  'Tipo de comando para EFPHOST.SYS
  MyRecord.Header.Cmd = CMDWRITEADDFIELD

  'Largo de los datos a enviar
  MyRecord.Length = Length

  ' Datos
  MyRecord.Buffer = Buffer

  ' Se enva el primer campo a EFPHOST.SYS. Unicamente se envia
  ' la cantidad necesaria de bytes
  PUT #1, , MyRecord

  'Se analiza "LastError"
  IF MyRecord.Header.LastError <> EFPSuccess THEN
    ' Manejar el error
    CALL HandleError("AddField - DriverError", MyRecord.Header.LastError)
  END IF
END SUB

'-----------------------------------------------------------------------------
' Function Name : GetExtraField
' Description   : Obtiene un campo de informacio extra.
' Input         : FS,PS,RC y numeros de campos extras.
' Outupt        : True si el resultado fue Ok
' Notes         :
'-----------------------------------------------------------------------------
SUB GetExtraField (Buffer AS STRING, IndexLen AS INTEGER)
DIM MyRecord AS tExtraField

  MyRecord.Header.Cmd = CMDREADEXTRAFIELDS
  MyRecord.IndexLength = IndexLen

  GET #1, , MyRecord

  IF MyRecord.Header.LastError <> EFPSuccess THEN
    'Manejar el error
    CALL HandleError("GetExtraField - DriverError", MyRecord.Header.LastError)
  END IF

  ' El campo buscado se encuentra en MyRecord.ExtraField.Buffer y el
  ' largo del mismo en MyRecord.ExtraField.IndexLength */
  IndexLen = MyRecord.IndexLength
  
  Buffer = MyRecord.Buffer
END SUB

'-----------------------------------------------------------------------------
' Function Name : GetFinalAnswer
' Description   : Obtiene la respuesta final de la impresora fiscal.
' Input         : FS,PS,RC y numeros de campos extras.
' Outupt        : True si el resultado fue Ok
' Notes         :
'-----------------------------------------------------------------------------
SUB GetFinalAnswer (FiscalStatus AS INTEGER, PrinterStatus AS INTEGER, ReturnCode AS INTEGER, ExtraFieldsCount AS INTEGER)
DIM MyRecord AS tFinalAnswer
  MyRecord.Header.Cmd = CMDREADANSWER
  GET #1, , MyRecord
 
  IF MyRecord.Header.LastError <> EFPSuccess THEN
    'Manejar el error
    CALL HandleError("ReadFinalAnswer - DriverError", MyRecord.Header.LastError)
  END IF
   
  FiscalStatus = MyRecord.FiscalStatus
  PrinterStatus = MyRecord.PrinterStatus
  ReturnCode = MyRecord.ReturnCode
  ExtraFieldsCount = MyRecord.ExtraFieldsCount
END SUB

'-----------------------------------------------------------------------------
' Function Name : GetLog
' Description   : Obtiene el log de comunicaciones.
' Input         : Buffer del usuario y largo
' Outupt        : Nada
' Notes         :
'-----------------------------------------------------------------------------
SUB GetLog (Buffer AS STRING, BufferLen AS INTEGER)
DIM LogBuffer AS tLogBuffer
  LogBuffer.Header.Cmd = CMDREADLOGS
  LogBuffer.LogLen = BufferLen

  GET #1, , LogBuffer

  IF LogBuffer.Header.LastError <> EFPSuccess THEN
    'Manejar el error
    CALL HandleError("GetLog - DriverError", LogBuffer.Header.LastError)
  END IF
  Buffer = LogBuffer.LogBuffer
  BufferLen = LogBuffer.LogLen
END SUB

'-----------------------------------------------------------------------------
' Function Name : HandleError
' Description   : Maneja el error en operaciones del driver.
' Input         : Mensage y numero de error.
' Outupt        : Nada
' Notes         :
'-----------------------------------------------------------------------------
SUB HandleError (Message AS STRING, ErrorNum AS INTEGER)
   PRINT "Error: " + Message
   SELECT CASE ErrorNum
      CASE EFPEOutBufferFull
         PRINT "ErrorNum: Buffer de datos lleno."
      CASE EFPEInvalidDataInField
         PRINT "ErrorNum: Datos invalidos."
      CASE EFPEWriteFail
         PRINT "ErrorNum: Operacion de escritura fallo."
      CASE EFPEReadTimeOut
         PRINT "ErrorNum: Error de comunicacion."
      CASE EFPENackReceived
         PRINT "ErrorNum: Error de transferencia de datos."
      CASE EFPEInvalidIndex
         PRINT "ErrorNum: Indice invalido."
      CASE EFPEBufferTooSmall
         PRINT "ErrorNum: Buffer es muy chico."
      CASE EFPEInvalidCommand
         PRINT "ErrorNum: Comando invalido."
   END SELECT
   SYSTEM
END SUB

'-----------------------------------------------------------------------------
' Function Name : Main
' Description   : Entrada principal del programa..
' Input         : Nada
' Outupt        : Nada
' Notes         :
'---------------------------------------------------------------------------*/
SUB main
  
  'Abre driver
  OPEN "EFPHOST" FOR BINARY AS #1

  ' Abre archivo de logeo
  OPEN "EFPLOG.LOG" FOR BINARY AS #2

  CALL TicketAndClosure

  'Cierra archivo de logeo
  CLOSE #2
END SUB

'-----------------------------------------------------------------------------
' Function Name : SendFrame
' Description   : Suma datos a la trama de envio.
' Input         : Nada
' Outupt        : Nada
' Notes         :
'-----------------------------------------------------------------------------
SUB SendFrame
DIM MyRecord AS tSendFrame
  
  ' Se enva todo a la impresora fiscal
  MyRecord.Header.Cmd = CMDWRITESEND
  
  PUT #1, , MyRecord

  'Se analiza "LastError"
  IF MyRecord.Header.LastError <> EFPSuccess THEN
    'Manejar el error
    CALL HandleError("SendFrame - DriverError", MyRecord.Header.LastError)
  END IF
END SUB

'-----------------------------------------------------------------------------
' Function Name : TicketAndClosure
' Description   : Realiza un ticket y un cierre de jornada.
' Input         : Nada
' Outupt        : Nada
' Notes         :
'-----------------------------------------------------------------------------
SUB TicketAndClosure
DIM Buffer AS STRING * 100
DIM Index AS INTEGER
DIM FS AS INTEGER
DIM PS AS INTEGER
DIM RC AS INTEGER
DIM GEFC AS INTEGER
  
  'Fijar tipo de pago
  PRINT "Setea tipo de pago"
  Buffer = CHR$(&H5) + CHR$(&HC)
  CALL AddField(Buffer, 2)
  Buffer = CHR$(&H0) + CHR$(&H0)
  CALL AddField(Buffer, 2)
  CALL AddField("2", 2)
  CALL AddField("Contado", 7)
  CALL SendFrame

  'Actualiza LOG de comunicaciones
  Index = 8191
  CALL GetLog(LogBuf, Index)
  FileBuf = MID$(LogBuf, 1, Index)
  PUT #2, , FileBuf

  'Muestra resultado del comando
  CALL GetFinalAnswer(FS, PS, RC, GEFC)
  PRINT "FS: " + HEX$(FS) + " PS: " + HEX$(PS) + " RC: " + HEX$(RC)

  'Abrir boleta fiscal 
  PRINT CHR$(13) + "Abre boleta fiscal"
  Buffer = CHR$(&HA) + CHR$(&H1)
  CALL AddField(Buffer, 2)
  Buffer = CHR$(&H0) + CHR$(&H0)
  CALL AddField(Buffer, 2)
  CALL AddField("", 0)
  CALL AddField("", 0)
  CALL SendFrame

  'Actualiza LOG de comunicaciones
  Index = 8191
  CALL GetLog(LogBuf, Index)
  FileBuf = MID$(LogBuf, 1, Index)
  PUT #2, , FileBuf

  'Muestra resultado del comando
  CALL GetFinalAnswer(FS, PS, RC, GEFC)
  PRINT "FS: " + HEX$(FS) + " PS: " + HEX$(PS) + " RC: " + HEX$(RC)

  'Item
  PRINT CHR$(13) + "Item ..."
  Buffer = CHR$(&HA) + CHR$(&H2)
  CALL AddField(Buffer, 2)
  Buffer = CHR$(&H0) + CHR$(&H0)
  CALL AddField(Buffer, 2)
  CALL AddField("Descripcion Extra", 17)
  CALL AddField("Descripcion Extra", 17)
  CALL AddField("Descripcion Extra", 17)
  CALL AddField("Descripcion Extra", 17)
  CALL AddField("Descripcion Extra", 17)
  CALL AddField("Descripcion del Item", 20)
  CALL AddField("10000", 5)
  CALL AddField("10000", 5)
  CALL AddField("2100", 4)
  CALL SendFrame

  'Actualiza LOG de comunicaciones
  Index = 8191
  CALL GetLog(LogBuf, Index)
  FileBuf = MID$(LogBuf, 1, Index)
  PUT #2, , FileBuf

  'Muestra resultado del comando
  CALL GetFinalAnswer(FS, PS, RC, GEFC)
  PRINT "FS: " + HEX$(FS) + " PS: " + HEX$(PS) + " RC: " + HEX$(RC)

  'Pago
  PRINT CHR$(13) + "Pago ..."
  Buffer = CHR$(&HA) + CHR$(&H5)
  CALL AddField(Buffer, 2)
  Buffer = CHR$(&H0) + CHR$(&H0)
  CALL AddField(Buffer, 2)
  CALL AddField("2", 1)
  CALL AddField("1", 1)
  CALL SendFrame
  
  'Actualiza LOG de comunicaciones
  Index = 8191
  CALL GetLog(LogBuf, Index)
  FileBuf = MID$(LogBuf, 1, Index)
  PUT #2, , FileBuf

  'Muestra resultado del comando
  CALL GetFinalAnswer(FS, PS, RC, GEFC)
  PRINT "FS: " + HEX$(FS) + " PS: " + HEX$(PS) + " RC: " + HEX$(RC)

  'Cerrar
  PRINT CHR$(13) + "Cierre ..."
  Buffer = CHR$(&HA) + CHR$(&H6)
  CALL AddField(Buffer, 2)
  Buffer = CHR$(&H0) + CHR$(&H1)
  CALL AddField(Buffer, 2)
  CALL AddField("1", 1)
  CALL AddField("Gracias por su Compra", 21)
  CALL AddField("", 0)
  CALL AddField("", 0)
  CALL AddField("", 0)
  CALL AddField("", 0)
  CALL SendFrame
  
  'Actualiza LOG de comunicaciones
  Index = 8191
  CALL GetLog(LogBuf, Index)
  FileBuf = MID$(LogBuf, 1, Index)
  PUT #2, , FileBuf

  'Muestra resultado del comando
  CALL GetFinalAnswer(FS, PS, RC, GEFC)
  PRINT "FS: " + HEX$(FS) + " PS: " + HEX$(PS) + " RC: " + HEX$(RC)
  
  'Closure X
  PRINT CHR$(13) + "Cierre Z"
  Buffer = CHR$(&H8) + CHR$(&H1)
  CALL AddField(Buffer, 2)
  Buffer = CHR$(&H0) + CHR$(&H0)
  CALL AddField(Buffer, 2)
  CALL SendFrame
  
  'Actualiza LOG de comunicaciones
  Index = 8191
  CALL GetLog(LogBuf, Index)
  FileBuf = MID$(LogBuf, 1, Index)
  PUT #2, , FileBuf

  'Muestra resultado del comando
  CALL GetFinalAnswer(FS, PS, RC, GEFC)
  PRINT "FS: " + HEX$(FS) + " PS: " + HEX$(PS) + " RC: " + HEX$(RC)

  'Muestra el numero de cierre Z
  Index = 1
  CALL GetExtraField(Buffer, Index)
  PRINT "Z numero " + Buffer
END SUB

