*=============================================================================
* EFPCLI.PRG                                                 EPSON Argentina
*=============================================================================
* EPSON Fiscal Printer Device driver example.
*=============================================================================
* Date             Author                  Comment
* 15-04-2004       Ricardo Malerba         Initial Version
*=============================================================================

*=============================================================================
* Proposito: Muestra uso del driver DOS bajo un programa en Clipper
* Operacion: Ticket de monto 1 + Cierre Z
* Compilador: Clipper 
* Linea de comando: CLIPPER EFPCLI
* Requisitos: Impresora fiscal serializada
*=============================================================================

* Max cantidad de datos a transmitir
#define EFPMAXFIELDLEN    2048

* Comandos del driver
#define CMDWRITEADDFIELD    '0'
#define CMDWRITESEND        '1'
#define CMDWRITEPURGE       '2'
#define CMDREADANSWER       '3'
#define CMDREADEXTRAFIELDS  '4'
#define CMDREADLOGS         '5'

* Retornos
#define EFPSuccess 0
#define EFPEOutBufferFull -1
#define EFPEInvalidDataInField -2
#define EFPEWriteFail -3
#define EFPEReadTimeOut -4
#define EFPENackReceived -5
#define EFPEInvalidIndex -6
#define EFPEBufferTooSmall -7
#define EFPEInvalidCommand -8

#include "Fileio.ch"

* Variables globales
PUBLIC nHandle, nLogHandle
PUBLIC cLogBuf := REPLICATE( CHR( 0 ), 1024 )

**************************************************************************
* Main procedure
**************************************************************************
 Main()
 
 QUIT

*-----------------------------------------------------------------------------
* Function Name : AddField
* Description   : Suma datos a la trama de envio.
* Input         : Buffer y largo
* Outupt        : Nada
* Notes         :
*-----------------------------------------------------------------------------
PROCEDURE AddField (cBuffer, nLength)
LOCAL cXBuffer, nLastError

   * Tipo de comando para EFPHOST.SYS
   cXBuffer := CHR(ASC( CMDWRITEADDFIELD ))

   * Espacio para el last error
   cXBuffer := cXBuffer + REPLICATE( CHR( 0 ), 2 )
   
   * Field length 
   cXBuffer := cXBuffer + I2BIN( nLength )
  
   * Buffer data
   cXBuffer := cXBuffer + cBuffer 
  
   * Se enva el primer campo a EFPHOST.SYS. Unicamente se envia
   * la cantidad necesaria de bytes
   FWRITE( nHandle, cXBuffer, LEN( cXBuffer ))
  
   * Se analiza "LastError"
   nLastError := BIN2W( SUBSTR( cXBuffer, 2, 2 ))
  
   IF nLastError != EFPSuccess 
     * Manejar el error
     HandleError('AddField - DriverError', nLastError)
   ENDIF

*-----------------------------------------------------------------------------
* Function Name : SendFrame
* Description   : Suma datos a la trama de envio.
* Input         : Nada
* Outupt        : Nada
* Notes         :
*-----------------------------------------------------------------------------
PROCEDURE SendFrame()
LOCAL cXBuffer, nLastError
  
   * Tipo de comando para EFPHOST.SYS
   cXBuffer := CHR(ASC( CMDWRITESEND ))

   * Espacio para el last error
   cXBuffer := cXBuffer + REPLICATE( CHR( 0 ), 2 )
   
   * Se enva el primer campo a EFPHOST.SYS. Unicamente se envia
   * la cantidad necesaria de bytes
   FWRITE( nHandle, cXBuffer, LEN( cXBuffer ))
  
   * Se analiza 'LastError'
   nLastError := BIN2W( SUBSTR( cXBuffer, 2, 2 ))
  
   IF nLastError != EFPSuccess 
     * Manejar el error
     HandleError('AddField - DriverError', nLastError)
   ENDIF

*-----------------------------------------------------------------------------
* Function Name : GetExtraField
* Description   : Obtiene un campo de informacio extra.
* Input         : FS,PS,RC y numeros de campos extras.
* Outupt        : Nada
* Notes         :
*-----------------------------------------------------------------------------
PROCEDURE GetExtraField (cBuffer, nIndexLen)
LOCAL cXBuffer, nLastError

   * Tipo de comando para EFPHOST.SYS
   cXBuffer := CHR(ASC( CMDREADEXTRAFIELDS ))

   * Espacio para el last error
   cXBuffer := cXBuffer + REPLICATE( CHR( 0 ), 2 )
   
   * Field length 
   cXBuffer := cXBuffer + I2BIN( nIndexLen )
  
   * Buffer data
   cXBuffer := cXBuffer + cBuffer 
  
   * Se enva el primer campo a EFPHOST.SYS. Unicamente se envia
   * la cantidad necesaria de bytes
   FREAD( nHandle, @cXBuffer, LEN( cXBuffer ))
  
   * Se analiza 'LastError'
   nLastError := BIN2W( SUBSTR( cXBuffer, 2, 2 ))
  
   IF nLastError != EFPSuccess 
     * Manejar el error
     HandleError('AddField - DriverError', nLastError)
   ENDIF

   * Actualiza largo
   nIndexLen := BIN2W( SUBSTR( cXBuffer, 4, 2 ))
   
   * Buffer
   cBuffer := SUBSTR( cXBuffer, 6, nIndexLen )

*-----------------------------------------------------------------------------
* Function Name : GetFinalAnswer
* Description   : Obtiene la respuesta final de la impresora fiscal.
* Input         : FS,PS,RC y numeros de campos extras.
* Outupt        : Nada
* Notes         :
*-----------------------------------------------------------------------------
PROCEDURE GetFinalAnswer (FiscalStatus, PrinterStatus, ReturnCode, ExtraFieldsCount )
LOCAL cXBuffer, nLastError
  
   * Tipo de comando para EFPHOST.SYS
   cXBuffer := CHR(ASC( CMDREADANSWER ))

   * Espacio para el last error
   cXBuffer := cXBuffer + REPLICATE( CHR( 0 ), 10 )
   
   * Se enva el primer campo a EFPHOST.SYS. Unicamente se envia
   * la cantidad necesaria de bytes
   FREAD( nHandle, @cXBuffer, LEN( cXBuffer ))
  
   * Se analiza LastError
   nLastError := BIN2W( SUBSTR( cXBuffer, 2, 2 ))
  
   IF nLastError != EFPSuccess 
     * Manejar el error
     HandleError('AddField - DriverError', nLastError)
   ENDIF
   
   FiscalStatus  := BIN2W( SUBSTR( cXBuffer, 4, 2 ))
   PrinterStatus := BIN2W( SUBSTR( cXBuffer, 6, 2 ))
   ReturnCode    := BIN2W( SUBSTR( cXBuffer, 8, 2 ))
   ExtraFieldsCount := BIN2W( SUBSTR( cXBuffer,10, 2 ))

*-----------------------------------------------------------------------------
* Function Name : GetLog
* Description   : Obtiene el log de comunicaciones.
* Input         : Buffer del usuario y largo
* Outupt        : Nada
* Notes         :
*-----------------------------------------------------------------------------
PROCEDURE GetLog( cBuffer, nBufferLen )
LOCAL cXBuffer, nLastError, nLength
  
   * Tipo de comando para EFPHOST.SYS
   cXBuffer := CHR(ASC( CMDREADLOGS ))

   * Espacio para el last error
   cXBuffer := cXBuffer + REPLICATE( CHR( 0 ), 2 )
   
   * Espacio para el largo 
   cXBuffer := cXBuffer + I2BIN( nBufferLen )
   
   * Buffer del usuario
   cXBuffer := cXBuffer + REPLICATE( CHR( 0 ), nBufferLen )
  
   * Se enva el primer campo a EFPHOST.SYS. Unicamente se envia
   * la cantidad necesaria de bytes
   FREAD( nHandle, @cXBuffer, LEN( cXBuffer ))
  
   * Se analiza LastError
   nLastError := BIN2W( SUBSTR( cXBuffer, 2, 2 ))
  
   IF nLastError != EFPSuccess 
     * Manejar el error
     HandleError('GetLog - DriverError', nLastError)
   ENDIF
   
   * Actualiza largo
   nLength := BIN2W( SUBSTR( cXBuffer, 4, 2 ))
   nBufferLen := nLength
   
   * Buffer
   cBuffer := SUBSTR( cXBuffer, 6, nLength )
  
*-----------------------------------------------------------------------------
* Function Name : HandleError
* Description   : Maneja el error en operaciones del driver.
* Input         : Mensage y numero de error.
* Outupt        : Nada
* Notes         :
*-----------------------------------------------------------------------------
PROCEDURE HandleError ( Message, ErrorNum )
   ? 'Error: ' + Message
   DO CASE 
      CASE ErrorNum = EFPEOutBufferFull
         ? 'ErrorNum: Buffer de datos lleno.'
      CASE ErrorNum = EFPEInvalidDataInField
         ? 'ErrorNum: Datos invalidos.'
      CASE ErrorNum = EFPEWriteFail
         ? 'ErrorNum: Operacion de escritura fallo.'
      CASE ErrorNum = EFPEReadTimeOut
         ? 'ErrorNum: Error de comunicacion.'
      CASE ErrorNum = EFPENackReceived
         ? 'ErrorNum: Error de transferencia de datos.'
      CASE ErrorNum = EFPEInvalidIndex
         ? 'ErrorNum: Indice invalido.'
      CASE ErrorNum = EFPEBufferTooSmall
         ? 'ErrorNum: Buffer es muy chico.'
      CASE ErrorNum = EFPEInvalidCommand
         ? 'ErrorNum: Comando invalido.'
   ENDCASE 
   QUIT

*-----------------------------------------------------------------------------
* Function Name : Main
* Description   : Entrada principal del programa..
* Input         : Nada
* Outupt        : Nada
* Notes         :
*-----------------------------------------------------------------------------
PROCEDURE main
LOCAL cBuffer,FS, PS, RC, GEFC
  
   * Abre driver
   nHandle := FOPEN( "EFPHOST", FO_READWRITE )            
   
   IF FERROR () != 0
      ? 'Error !!! Driver no instalado.'
      RETURN
   ENDIF
   
   * Abre LOG
   nLogHandle := FOPEN( "EFPLOG.LOG", FO_READWRITE )
   
   IF nLogHandle == -1 
      nLogHandle := FCREATE( "EFPLOG.LOG" )
   ENDIF
   
   * Ejecuta boleta + cierre Z                  
   TicketAndClosure()
  
   * Cierra driver
   FCLOSE( nHandle )
   FCLOSE( nLogHandle )
  
*-----------------------------------------------------------------------------
* Function Name : TicketAndClosure
* Description   : Realiza un ticket y un cierre de jornada.
* Input         : Nada
* Outupt        : Nada
* Notes         :
*-----------------------------------------------------------------------------
PROCEDURE TicketAndClosure
LOCAL cBuffer, nIndex, FS, PS, RC, GEFC 
  
   * Fijar tipo de pago
   ? 'Setea tipo de pago'
   cBuffer := CHR(5) + CHR(12)
   AddField(cBuffer, 2)
   cBuffer := CHR(0) + CHR(0)
   AddField(cBuffer, 2)
   AddField('2', 2)
   AddField('Contado', 7)
   SendFrame()
   
   * Actualiza LOG de comunicaciones
   nIndex := 1023
   GetLog(@cLogBuf, @nIndex)
   FWRITE( nLogHandle, cLogBuf, nIndex )
   
   * Muestra resultado del comando
   GetFinalAnswer(@FS, @PS, @RC, @GEFC)
   ? 'FS: ' + STR(FS) + ' PS: ' + STR(PS) + ' RC: ' + STR(RC)
   
   * Abrir boleta fiscal 
   ? CHR(13) + 'Abre boleta fiscal'
   cBuffer := CHR(10) + CHR(1)
   AddField(cBuffer, 2)
   cBuffer := CHR(0) + CHR(0)
   AddField(cBuffer, 2)
   AddField('', 0)
   AddField('', 0)
   SendFrame()
   
   * Actualiza LOG de comunicaciones
   nIndex := 1023
   GetLog(@cLogBuf, @nIndex)
   FWRITE( nLogHandle, cLogBuf, nIndex )
   
   * Muestra resultado del comando
   GetFinalAnswer(@FS, @PS, @RC, @GEFC)
   ? 'FS: ' + STR(FS) + ' PS: ' + STR(PS) + ' RC: ' + STR(RC)
   
   * Item
   ? CHR(13) + 'Item ...'
   cBuffer := CHR(10) + CHR(2)
   AddField(cBuffer, 2)
   cBuffer := CHR(0) + CHR(0)
   AddField(cBuffer, 2)
   AddField('Descripcion Extra', 17)
   AddField('Descripcion Extra', 17)
   AddField('Descripcion Extra', 17)
   AddField('Descripcion Extra', 17)
   AddField('Descripcion Extra', 17)
   AddField('Descripcion del Item', 20)
   AddField('10000', 5)
   AddField('10000', 5)
   AddField('2100', 4)
   SendFrame()
   
   * Actualiza LOG de comunicaciones
   nIndex := 1023
   GetLog(@cLogBuf, @nIndex)
   FWRITE( nLogHandle, cLogBuf, nIndex )
   
   * Muestra resultado del comando
   GetFinalAnswer(@FS, @PS, @RC, @GEFC)
   ? 'FS: ' + STR(FS) + ' PS: ' + STR(PS) + ' RC: ' + STR(RC)
   
   * Pago
   ? CHR(13) + 'Pago ...'
   cBuffer := CHR(10) + CHR(5)
   AddField(cBuffer, 2)
   cBuffer := CHR(0) + CHR(0)
   AddField(cBuffer, 2)
   AddField('2', 1)
   AddField('1', 1)
   SendFrame()
   
   * Actualiza LOG de comunicaciones
   nIndex := 1023
   GetLog(@cLogBuf, @nIndex)
   FWRITE( nLogHandle, cLogBuf, nIndex )
   
   * Muestra resultado del comando
   GetFinalAnswer(@FS, @PS, @RC, @GEFC)
   ? 'FS: ' + STR(FS) + ' PS: ' + STR(PS) + ' RC: ' + STR(RC)
   
   * Cerrar
   ? CHR(13) + 'Cierre ...'
   cBuffer := CHR(10) + CHR(6)
   AddField(cBuffer, 2)
   cBuffer := CHR(0) + CHR(1)
   AddField(cBuffer, 2)
   AddField('1', 1)
   AddField('Gracias por su Compra', 21)
   AddField('', 0)
   AddField('', 0)
   AddField('', 0)
   AddField('', 0)
   SendFrame()
   
   * Actualiza LOG de comunicaciones
   nIndex := 1023
   GetLog(@cLogBuf, @nIndex)
   FWRITE( nLogHandle, cLogBuf, nIndex )
   
   * Muestra resultado del comando
   GetFinalAnswer(@FS, @PS, @RC, @GEFC)
   ? 'FS: ' + STR(FS) + ' PS: ' + STR(PS) + ' RC: ' + STR(RC)
   
   * Closure X
   ? CHR(13) + 'Cierre Z'
   cBuffer := CHR(8) + CHR(1)
   AddField(cBuffer, 2)
   cBuffer := CHR(0) + CHR(0)
   AddField(cBuffer, 2)
   SendFrame()
   
   * Actualiza LOG de comunicaciones
   nIndex := 1023
   GetLog(@cLogBuf, @nIndex)
   FWRITE( nLogHandle, cLogBuf, nIndex )
   
   * Muestra resultado del comando
   GetFinalAnswer(@FS, @PS, @RC, @GEFC)
   ? 'FS: ' + STR(FS) + ' PS: ' + STR(PS) + ' RC: ' + STR(RC)
   
   * Muestra el numero de cierre Z
   Index := 1
   cBuffer := REPLICATE( '0', EFPMAXFIELDLEN )
   GetExtraField(@cBuffer, @Index)
   ? 'Z numero ' + cBuffer

